package com.xdja.cssp.group.scheduling;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class CacheScheduling {
private static Logger logger = LoggerFactory.getLogger(CacheScheduling.class);
	
	private static ScheduledThreadPoolExecutor stpe = null;
	
	
	
	/**
	 * 延迟5秒后启动好友数据缓存定时调度任务，每300秒执行一次 
	 */
	public static void start() {
		start(300, TimeUnit.SECONDS);
	}
	
	/**
	 * 
	 * 延迟5秒后启动好友数据缓存定时调度任务，每指定的时间内执行一次
	 * @param period
	 * @param unit   时间单位
	 */
	public static void start(int delay, TimeUnit unit) {
		stpe = new ScheduledThreadPoolExecutor(1);
		stpe.scheduleWithFixedDelay(new Runnable() {
			
			@Override
			public void run() {
				try {
					GroupDataChacher.startCache();
				} catch (Exception e) {
					logger.error("Cache Schedule error.", e);
				}
			}
		}, 5, delay, unit);
	}
}
