package com.xdja.cssp.group.scheduling;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import com.xdja.cssp.group.business.GroupCacheOperator;
import com.xdja.cssp.group.business.IGroupBusiness;

@Component
public class GroupDataChacher implements ApplicationContextAware {

	private static Logger logger = LoggerFactory.getLogger(GroupDataChacher.class);
	
	private static IGroupBusiness groupBusiness;
	
	private final static int BATCH_SIZE = 1000;
	
	@Override
	public void setApplicationContext(ApplicationContext applicationContext)
			throws BeansException {
		groupBusiness = applicationContext.getBean(IGroupBusiness.class);
	}
	
	public static synchronized void startCache() {
		long memberSeq = 0;
		try {
			// 获取redis更新序列
			memberSeq = GroupCacheOperator.getGroupMemberSeq();
			logger.info("memberSeq in cache is {}. now begin to cache from db.", memberSeq);
			List<CacheMemberBean> cacheMemberBeans = groupBusiness.queryDataForCache(memberSeq, BATCH_SIZE);
			while(cacheMemberBeans != null && !cacheMemberBeans.isEmpty()) {
				memberSeq = cacheMemberBeans.get(cacheMemberBeans.size() -1).getUpdateSerial();
				logger.info("find {} data to cache. memberSeq:{}.", cacheMemberBeans.size(), memberSeq);
				GroupCacheOperator.cacheGroupData(cacheMemberBeans, memberSeq);
				logger.info("Cached {} data. memberSeq:{}.", cacheMemberBeans.size(), memberSeq);
				if(cacheMemberBeans.size() < BATCH_SIZE) {
					break;
				}
				cacheMemberBeans = groupBusiness.queryDataForCache(memberSeq, BATCH_SIZE);
				
			}
		} catch (Exception e) {
			logger.error("定时缓存群组数据出错", e);
		}
		logger.info("cache from db success, and now memberseq is {}.", memberSeq);
	}
	
	
}
