package com.xdja.cssp.group.server;

import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

import com.xdja.cssp.group.scheduling.CacheScheduling;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.rpc.consumer.ServicePool;

@Component
public class GroupModule  implements InitializingBean {

	private Logger logger = LoggerFactory.getLogger(getClass());
	
	
	@Override
	public void afterPropertiesSet() throws Exception {
		Prop prop = PropKit.use("system.properties");
		
		int cacheInterval = prop.getInt("group.cache.interval", 300);
		CacheScheduling.start(cacheInterval, TimeUnit.SECONDS);
		logger.info("start cache task success. will update cache every {} second.", cacheInterval);
		ServicePool.addLocalService("group");
	}

}
