package com.xdja.cssp.group.service;

import java.util.List;
import java.util.Map;

import com.xdja.cssp.group.entity.AddMembersResult;
import com.xdja.cssp.group.entity.CreateGroupRequest;
import com.xdja.cssp.group.entity.CreateGroupResult;
import com.xdja.cssp.group.entity.Group;
import com.xdja.cssp.group.entity.ModifyGroupNicknameResult;
import com.xdja.platform.rpc.RemoteService;

@RemoteService(serviceCode = "group")
public interface IGroupService {
	
	
	/**
	 * 创建群组
	 * @param group 群组信息
	 * @return 创建后包含群id的群组信息
	 */
	CreateGroupResult createGroup(CreateGroupRequest createGroupRequest);
	
	
	/**
	 * 获取某个群组中的成员数量
	 * @param groupId 群id
	 * @return 群组中成员数量
	 */
	int getGroupMemberNum(long groupId);
	
	/**
	 * 获得一个群的所有成员
	 * 
	 * @param groupId
	 * @return 群成员列表
	 */
	
	List<String> getGroupAllMembers(String groupId);

	/**
	 * 获取某个账号的群组数
	 * @param account
	 * @return
	 */
	int getGroupNum(String account);
	
	/**
	 * 删除数据,仅仅用于创建群组，上传ksg失败时，回删群组
	 */
	public void deleteGroupForRollBack(long groupId);
	
	
	/**
	 * 查询群组信息
	 * @param groupId 群id
	 */
	public Group queryGroupDetail(long groupId);
	
	/**
	 * 只查询群组信息，不查询群成员
	 * @param groupId 群组id
	 * @return 群组信息，不包含群成员
	 */
	public Group queryGroupInfoOnly(long groupId);
	
	/**
	 * 修改群组名称
	 * @param groupId 群id
	 * @param updateGroupName 群名称
	 */
	public Map<String, String> modifyGroupName(long groupId, String updateGroupName);
	
	/**
	 * 修改群头像
	 * @param group
	 */
	void modifyGroupAvatar(Group group);
	
	/**
	 * 增量更新群信息
	 * @param account 账号
	 * @param updateSerial 更新序列
	 * @return 群组信息
	 */
	List<Group> queryGroups(String account, long updateSerial);
	
	/**
	 * 增量群成员信息
	 * @param paramMapList 参数信息，群组id及更新序列组成的map
	 * @return
	 */
	List<Map<String, Object>> queryMembers(List<Map<String, Long>> paramMapList);
	
	/**
	 * 退出群组
	 * @param groupId 群组id
	 * @param account 账号
	 */
	void quitGroup(long groupId, String account);
	
	/**
	 * 解散群组
	 * @param groupId
	 */
	void dismissGroup(long groupId);
	
	/**
	 * 批量移除群成员
	 * @param groupId 要移除的群组id
	 * @param removeAccounts 要移除的成员账号列表
	 */
	void removeGroupMembers(long groupId, List<String> removeAccounts);
	
	/**
	 * 添加群成员
	 * @param groupId 群id
	 * @param groupMembers 群成员
	 */
	AddMembersResult addGroupMembers(long groupId, int groupNum, String inviter, List<String> addAccounts);

	/**
	 * 修改群昵称
	 * @param groupId 群id
	 * @param newNickname 群昵称
	 * @return 
	 */
	ModifyGroupNicknameResult modifyGroupNickname(long groupId, String account, String newNickname);
	
	
	
}
