package com.xdja.cssp.group.service.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xdja.cssp.group.business.GroupCacheOperator;
import com.xdja.cssp.group.business.IGroupBusiness;
import com.xdja.cssp.group.entity.AddMembersResult;
import com.xdja.cssp.group.entity.CreateGroupRequest;
import com.xdja.cssp.group.entity.CreateGroupResult;
import com.xdja.cssp.group.entity.Group;
import com.xdja.cssp.group.entity.ModifyGroupNicknameResult;
import com.xdja.cssp.group.service.IGroupService;
import com.xdja.cssp.group.util.CheckParam;

@Service
public class GroupServiceImplV2 implements IGroupService {
	
	@Autowired
	private IGroupBusiness groupBusiness;
	
	
	@Override
	public CreateGroupResult createGroup(CreateGroupRequest createGroupRequest) {
		CheckParam.checkObject(createGroupRequest);
		CheckParam.check(createGroupRequest.getMemberAccounts());
		return groupBusiness.createGroup(createGroupRequest);
	}
	
	@Override
	public AddMembersResult addGroupMembers(long groupId, int groupNum, String inviter, List<String> addAccounts) {
		return groupBusiness.addGroupMembers(groupId, groupNum, inviter, addAccounts);
	}

	@Override
	public int getGroupMemberNum(long groupId) {
		return groupBusiness.getGroupMemberNum(groupId);
	}


	@Override
	public int getGroupNum(String account) {
		return groupBusiness.getGroupNum(account);
	}


	@Override
	public void deleteGroupForRollBack(long groupId) {
		groupBusiness.deleteGroupForever(groupId);
	}
	
	
	
	@Override
	public Group queryGroupDetail(long groupId) {
		return groupBusiness.queryGroupDetail(groupId);
	}
	
	
	@Override
	public Map<String, String> modifyGroupName(long groupId, String updateGroupName) {
		return groupBusiness.modifyGroupName(groupId, updateGroupName);
	}
	
	
	@Override
	public Group queryGroupInfoOnly(long groupId) {
		return null;
	}
	
	
	@Override
	public void modifyGroupAvatar(Group group) {
		groupBusiness.modifyGroupAvatar(group);
	}
	
	@Override
	public List<Group> queryGroups(String account, long updateSerial) {
		return groupBusiness.queryGroups(account, updateSerial);
	}


	@Override
	public List<Map<String, Object>> queryMembers(
			List<Map<String, Long>> paramMapList) {
		return groupBusiness.queryMembers(paramMapList);
	}
	
	
	
	@Override
	public void quitGroup(long groupId, String account) {
		groupBusiness.doQuitGroup(groupId, account);
	}


	@Override
	public void dismissGroup(long groupId) {
		groupBusiness.doDismissGroup(groupId);
	}
	
	@Override
	public void removeGroupMembers(long groupId, List<String> removeAccounts) {
		groupBusiness.removeGroupMembers(groupId, removeAccounts);
	}
	
	@Override
	public ModifyGroupNicknameResult modifyGroupNickname(long groupId, String account, String newNickname) {
		return groupBusiness.modifyGroupNickname(groupId, account, newNickname);
	}

	@Override
	public List<String> getGroupAllMembers(String groupId)
	{
		
		return groupBusiness.getGroupMembers(groupId);
	}

	
}
