package com.xdja.cssp.group.util;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

/**
 * @ProjectName：server-business
 * @ClassName：CheckParam
 * @Description：验证参数
 * @author: mayanpei
 * @date: 2015-7-28 下午4:36:50
 * 
 */
public class CheckParam {

	public static void check(Long param1, Long param2) throws IllegalArgumentException {
		if (param1 == null || param1 < 0) {
			throw new IllegalArgumentException("请求参数非法");
		}
		if (null == param2 || param2 < 0) {
			throw new IllegalArgumentException("请求参数非法");
		}
	}
	public static void check(Long param1, Long param2, Long param3) throws IllegalArgumentException {
		if (param1 == null || param1 < 0) {
			throw new IllegalArgumentException("请求参数非法");
		}
		if (null == param2 || param2 < 0) {
			throw new IllegalArgumentException("请求参数非法");
		}
		if (null == param3 || param3 < 0) {
			throw new IllegalArgumentException("请求参数非法");
		}
	}

	public static void check(Long param) throws IllegalArgumentException {
		if (null == param || param < 0) {
			throw new IllegalArgumentException("请求参数非法");
		}
	}

	public static void check(String param) {
		if (StringUtils.isBlank(param)) {
			throw new IllegalArgumentException("请求参数非法");
		}
	}

	public static <T> void check(List<T> list) {
		if (list == null || list.size() < 1) {
			throw new IllegalArgumentException("请求参数非法");
		}
	}

	public static void check(String param1, Long param2) {
		if (StringUtils.isBlank(param1)) {
			throw new IllegalArgumentException("请求参数非法");
		}

		if (null == param2 || param2 < 0) {
			throw new IllegalArgumentException("请求参数非法");
		}
	}
	
	/**
	 * 校验对象是否为空
	 * @param obj
	 */
	public static void checkObject(Object obj) {
		if(obj == null) {
			throw new IllegalArgumentException("请求参数非法");
		}
	}
	
}
