package com.xdja.cssp.group.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

import org.apache.commons.lang3.StringUtils;

/**
 * 拼音工具类
 * 
 * @author zhouyj
 * 
 */
public class PinyinUtil {
	/**
	 * 获取汉字的拼音首字母小写
	 */
	public static String getCharactersPy(String characters) {
	
		if(StringUtils.isEmpty(characters)) {
			return "";
		}
		characters = characters.replaceAll(" ", "");
		
		HanyuPinyinOutputFormat format=new HanyuPinyinOutputFormat();
		String[] py = null;
		StringBuffer charactersPY = new StringBuffer();
		for (int j = 0; j < characters.length(); j++ ) {
			char c = characters.charAt(j);
			
			format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
			format.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
			try {
				py = PinyinHelper.toHanyuPinyinStringArray(c, format);
				if(py == null || py.length == 0) {
					py = new String[] {String.valueOf(c)};
				}
			} catch (BadHanyuPinyinOutputFormatCombination e) {
				py = new String[] {String.valueOf(c)};
			}
			charactersPY.append(py[0].charAt(0));	
		}
		return charactersPY.toString();
	}
	
	/**
	 * 获取汉字的拼音
	 * @param characters 
	 * @return
	 */
	public static String getCharactersPinyin(String characters) {
		if(StringUtils.isEmpty(characters)) {
			return "";
		}
		
		characters = characters.replaceAll(" ", "");
		HanyuPinyinOutputFormat format=new HanyuPinyinOutputFormat();
		String[] py = null;
		StringBuffer charactersPinyin = new StringBuffer();
		for (int j = 0; j < characters.length(); j++ ) {
			char c = characters.charAt(j);
			
			format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
			format.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
			format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
			try {
				py = PinyinHelper.toHanyuPinyinStringArray(c, format);
				if(py == null || py.length == 0) {
					py = new String[] {String.valueOf(c)};
				}
			} catch (BadHanyuPinyinOutputFormatCombination e) {
				py = new String[] {String.valueOf(c)};
			}
			charactersPinyin.append(py[0]);	
		}
		return charactersPinyin.toString();
	}
	
}