package com.xdja.contactclient.bean;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 创建群组结果
 * @author zhouyj
 *
 */
public class CreateGroupResult implements Serializable {
	
	private static final long serialVersionUID = 4312689337895292550L;

	/**
	 * 创建群组结果，成功
	 */
	public static int RET_SUCCESS = 0;

	/**
	 * 创建群组结果，因群主所在群数量超限而失败
	 */
	public static int RET_OWNER_EXCESS = -1;
	
	/**
	 * 群成员数量超限
	 */
	public static int RET_MEMBER_COUNT_EXCESS = -2;
	
	/**
	 * 创建群组结果，部分成功
	 */
	public static int RET_PARTIAL_SUCCESS = -3;

	/**
	 * 群成员所在群数量超限
	 */
	public static int GROUP_MEMBER_EXCEED = -1;
	
	
	//创建成功后的群组信息
	private Group group;
	
	//创建结果 0-成功，1-部分人员
	private int retFlag;

	public Long getMemberSeq()
	{
		return memberSeq;
	}

	public void setMemberSeq(Long memberSeq)
	{
		this.memberSeq = memberSeq;
	}

	private Long memberSeq;//群成员最大更新序列
	
	

	
	//失败的账号信息，使用key来标识失败原因，使用value值来标记某种原因失败的账号列表
	private Map<Integer, List<String>> errMap;

	public Group getGroup() {
		return group;
	}
	public void setGroup(Group group) {
		this.group = group;
	}
	public int getRetFlag() {
		return retFlag;
	}
	public void setRetFlag(int retFlag) {
		this.retFlag = retFlag;
	}
	public Map<Integer, List<String>> getErrMap() {
		return errMap;
	}
	public void setErrMap(Map<Integer, List<String>> errMap) {
		this.errMap = errMap;
	}
	@Override
	public String toString() {
		return "CreateGroupResult [group=" + group + ", retFlag=" + retFlag
				+ ", errMap=" + errMap + ", memberSeq"+ memberSeq + "]";
	}
	
	
	
}
