package com.xdja.contactclient.common;

import java.io.Serializable;

/**
 * 
 * 集团通讯录更新检测结果
 * @date 2015-7-7
 * @author rrx
 *
 */
public class DetectContactRes implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * 更新状态: 0-无更新
	 */
	public static final int CHECKSTATUS_NONE = 0;
	/**
	 * 更新状态: 1-部门需要更新
	 */
	public static final int CHECKSTATUS_DEPT_UPDATE = 1;
	/**
	 * 更新状态: 2-人员需要更新
	 */
	public static final int CHECKSTATUS_PERSON_UPDATE = 2;
	/**
	 * 3-都需要更新
	 */
	public static final int CHECKSTATUS_UPDATE_ALL = 3;

	/**
	 * 0-无更新；1-部门需要更新；2-人员需要更新；3-都需要更新
	 */
	private int checkStatus;
	
	/**
	 * 集团通讯录所属的集团编号
	 */
	private String companyCode;

	/**
	 * 人员更新截止ID
	 */
	private Long personSubUpdateId;

	/**
	 * 部门更新截止ID
	 */
	private Long deptSubUpdateId;

	/**
	 * 部门、人员更新总条数
	 */
	private int totalSize;

	/**
	 * @return 获取{@link #checkStatus}
	 */
	public int getCheckStatus() {
		return checkStatus;
	}

	/**
	 * 设置{@link #checkStatus}
	 * 
	 * @param checkStatus
	 *            checkStatus
	 */
	public void setCheckStatus(int checkStatus) {
		this.checkStatus = checkStatus;
	}

	/**
	 * @return 获取{@link #personSubUpdateId}
	 */
	public Long getPersonSubUpdateId() {
		return personSubUpdateId;
	}

	/**
	 * 设置{@link #personSubUpdateId}
	 * 
	 * @param personSubUpdateId
	 *            personSubUpdateId
	 */
	public void setPersonSubUpdateId(Long personSubUpdateId) {
		this.personSubUpdateId = personSubUpdateId;
	}

	/**
	 * @return 获取{@link #deptSubUpdateId}
	 */
	public Long getDeptSubUpdateId() {
		return deptSubUpdateId;
	}

	/**
	 * 设置{@link #deptSubUpdateId}
	 * 
	 * @param deptSubUpdateId
	 *            deptSubUpdateId
	 */
	public void setDeptSubUpdateId(Long deptSubUpdateId) {
		this.deptSubUpdateId = deptSubUpdateId;
	}

	/**
	 * @return 获取{@link #totalSize}
	 */
	public int getTotalSize() {
		return totalSize;
	}

	/**
	 * 设置{@link #totalSize}
	 * 
	 * @param totalSize totalSize
	 */
	public void setTotalSize(int totalSize) {
		this.totalSize += totalSize;
	}
	

	/**
	 * @return 返回{@linkplain #companyCode}
	 */
	public String getCompanyCode() {
		return companyCode;
	}

	/**
	 * @param companyCode 要设置的 {@linkplain #companyCode}
	 */
	public void setCompanyCode(String companyCode) {
		this.companyCode = companyCode;
	}

	@Override
	public String toString() {
		return "CheckContactResult [checkStatus=" + checkStatus
				+ ", deptSubUpdateId=" + deptSubUpdateId
				+ ", personSubUpdateId=" + personSubUpdateId + ", totalSize="
				+ totalSize + "]";
	}

}
