package com.xdja.contactclient.rpcstubpool;

import com.xdja.contact.thrift.datatype.ResStr;
import com.xdja.contactclient.common.DefaultValues;
import com.xdja.contactclient.common.ReturnValues;
import com.xdja.contact.thrift.stub.ContactEcService;
import com.xdja.contact.thrift.stub.ContactFriendService;
import com.xdja.contact.thrift.stub.ContactGroupService;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;

public class RpcStubPoolFactory extends BaseKeyedPoolableObjectFactory<String, Object>
{
	private final String host;
	private final int port;
	private final int serverMode;
	private final int timeout;
	public AtomicInteger logId = new AtomicInteger(-1);
	private static Logger logger = LoggerFactory.getLogger(RpcStubPoolFactory.class);

	private String getClassName()
	{// 仅用于内部获取类的最短名字
		return "RpcStubPoolFactory";
	}

	public RpcStubPoolFactory(final String host, final int port, final int mode, final int timeout)
	{
		super();
		this.host = host;
		this.port = port;
		this.serverMode = mode;
		this.timeout = timeout;
	}

	public boolean checkSocket(Socket socket)
	{
		return socket != null && socket.isBound() && !socket.isClosed() && socket.isConnected() && !socket.isInputShutdown() && !socket.isOutputShutdown();
	}

	@SuppressWarnings("unchecked") @Override public Object makeObject(String key) throws Exception
	{
		String logFlag = getClassName() + ".makeObject";
		TTransport transport = null;
		TProtocol protocol = null;
		TSocket tsocket = null;
		if (serverMode == DefaultValues.SERVER_MODE_THREAD_POOL)
		{
			tsocket = new TSocket(this.host, this.port, this.timeout);
			transport = tsocket;
			protocol = new TBinaryProtocol(transport);
		}
		else if (serverMode == DefaultValues.SERVER_MODE_NONBLOCK || serverMode == DefaultValues.SERVER_MODE_THREADEDSELECTOR)
		{
			tsocket = new TSocket(this.host, this.port, this.timeout);
			transport = new TFramedTransport(tsocket);
			// 协议要和服务端一致
			protocol = new TBinaryProtocol(transport);
		}
		TMultiplexedProtocol multiPro = new TMultiplexedProtocol(protocol, key);
		try
		{
			Object rpctype = null;
			switch (key)
			{
			case DefaultValues.CONTACT_EC_SERVICE:
				rpctype = new RpcClientInfo<ContactEcService.Client>(new ContactEcService.Client(multiPro), transport, tsocket);
				((RpcClientInfo<ContactEcService.Client>) rpctype).getTTransport().open();
				break;
			case DefaultValues.CONTACT_FRIEND_SERVICE:
				rpctype = new RpcClientInfo<ContactFriendService.Client>(new ContactFriendService.Client(multiPro), transport, tsocket);
				((RpcClientInfo<ContactFriendService.Client>) rpctype).getTTransport().open();
				break;
			case DefaultValues.CONTACT_GROUP_SERVICE:
				rpctype = new RpcClientInfo<ContactGroupService.Client>(new ContactGroupService.Client(multiPro), transport, tsocket);
				((RpcClientInfo<ContactGroupService.Client>) rpctype).getTTransport().open();
				break;
			default:
				break;
			}
			return rpctype;
		}
		catch (TTransportException e)
		{
			logger.warn("[lid:{}][{}]getTTransport failed! TTransportException detail: {}", logId.getAndDecrement(), logFlag, e);
			return null;
		}
	}

	@Override public boolean validateObject(String key, Object obj)
	{
		String logFlag = getClassName() + ".validateObject";
		logId.getAndIncrement();
		if (obj == null)
		{
			logger.warn("[lid:{}][{}]Object is empty!", logId.get(), logFlag);
			return false;
		}
		ResStr resStr = null;
		try
		{
			switch (key)
			{
			case DefaultValues.CONTACT_EC_SERVICE:
				RpcClientInfo<ContactEcService.Client> rpcec = (RpcClientInfo<ContactEcService.Client>) obj;
				if (!checkSocket(rpcec.getTSocket().getSocket()))
				{
					logger.warn("[lid:{}][{}] checkSocket fail!", logId.get(), logFlag);
					return false;
				}
				resStr = rpcec.getClient().echo(logId.getAndIncrement(), logFlag, "ok");
				if (resStr.res != ReturnValues.SUCCESS)
				{
					logger.warn("[lid:{}][{}] err result!", logId.get(), logFlag);
					return false;
				}
				return resStr.value.equals("ok");
			case DefaultValues.CONTACT_FRIEND_SERVICE:
				RpcClientInfo<ContactFriendService.Client> rpcfriend = (RpcClientInfo<ContactFriendService.Client>) obj;
				if (!checkSocket(rpcfriend.getTSocket().getSocket()))
				{
					logger.warn("[lid:{}][{}] checkSocket fail!", logId.get(), logFlag);
					return false;
				}
				resStr = rpcfriend.getClient().echo(logId.getAndIncrement(), logFlag, "ok");
				if (resStr.res != ReturnValues.SUCCESS)
				{
					logger.warn("[lid:{}][{}] err result!", logId.get(), logFlag);
					return false;
				}
				return resStr.value.equals("ok");
			case DefaultValues.CONTACT_GROUP_SERVICE:
				RpcClientInfo<ContactGroupService.Client> rpcgroup = (RpcClientInfo<ContactGroupService.Client>) obj;
				if (!checkSocket(rpcgroup.getTSocket().getSocket()))
				{
					logger.warn("[lid:{}][{}] checkSocket fail!", logId.get(), logFlag);
					return false;
				}
				resStr = rpcgroup.getClient().echo(logId.getAndIncrement(), logFlag, "ok");
				if (resStr.res != ReturnValues.SUCCESS)
				{
					logger.warn("[lid:{}][{}] err result!", logId.get(), logFlag);
					return false;
				}
				return resStr.value.equals("ok");
			default:
				break;
			}
			return super.validateObject(key, obj);
		}
		catch (Exception e)
		{
			logger.warn("[lid:{}][{}]validateObject fail! Exception detail:{}", logId.get(), logFlag, e);
			return false;
		}

	}

	@Override public void destroyObject(String key, Object obj) throws Exception
	{
		String logFlag = getClassName() + ".destroyObject";
		if (obj == null)
		{
			logger.warn("[lid:{}][{}]Object is empty!", logId.getAndDecrement(), logFlag);
			return;
		}
		switch (key)
		{
		case DefaultValues.CONTACT_EC_SERVICE:
			RpcClientInfo<ContactEcService.Client> rpcec = (RpcClientInfo<ContactEcService.Client>) obj;
			rpcec.getTTransport().close();
			break;
		case DefaultValues.CONTACT_FRIEND_SERVICE:
			RpcClientInfo<ContactFriendService.Client> rpcfr = (RpcClientInfo<ContactFriendService.Client>) obj;
			rpcfr.getTTransport().close();
			break;
		case DefaultValues.CONTACT_GROUP_SERVICE:
			RpcClientInfo<ContactGroupService.Client> rpcgr = (RpcClientInfo<ContactGroupService.Client>) obj;
			rpcgr.getTTransport().close();
			break;
		default:
			break;
		}
		RpcStubPool.iNum.decrementAndGet();
	}

}
