package com.xdja.cssp.restful.exception.handler;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import com.xdja.cssp.restful.auth.exception.AuthException;
import com.xdja.cssp.restful.bean.ResponseError;


/**
 * 异常处理类，将实际的异常转换为异常json字符串返回给客户端，
 * 并且根据异常类型返回对应的状态码
 * @author yk
 *
 */
@ControllerAdvice
public class AuthExceptionHandler {

	private Logger logger = LoggerFactory.getLogger(AuthExceptionHandler.class);
	
	/**
	 * 认证异常
	 * @param exception
	 * @return
	 */
	@ExceptionHandler(AuthException.class)
	@ResponseBody
	public Object handleAuthException(AuthException exception, HttpServletResponse httpservletResponse) {
		httpservletResponse.setStatus(exception.getStatus());
		return convertError(exception);
	}
	
	
	/**
	 * 转换异常为对应的异常返回对象
	 * @param exception
	 * @return
	 */
	public ResponseError convertError(AuthException exception) {
		ResponseError response = new ResponseError();
		response.setRequestId(exception.getRequestId());
		response.setHostId(exception.getHostId());
		response.setErrCode(exception.getErrCode());
		response.setMessage(exception.getMessage());
		logger.debug("error response:" + response.toString(), exception);
		return response;
	}
}
