/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.restful.exception.handler;

import com.xdja.cssp.restful.auth.exception.AuthException;
import com.xdja.cssp.restful.bean.ResponseError;
import com.xdja.cssp.restful.exception.ApiException;
import com.xdja.cssp.restful.exception.ApiExceptionResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ApiExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={ApiException.class})
    @ResponseBody
    public Object handleApiException(ApiException exception, HttpServletResponse httpservletResponse) {
        this.saveLog(exception);
        httpservletResponse.setStatus(exception.getStatus());
        return this.convert(exception);
    }

    public ApiExceptionResponse convert(ApiException exception) {
        ApiExceptionResponse response = new ApiExceptionResponse();
        response.setRequestId(exception.getRequestId());
        response.setHostId(exception.getHostId());
        response.setErrCode(exception.getErrCode());
        response.setMessage(exception.getMessage());
        return response;
    }

    public ResponseError convertError(AuthException exception) {
        ResponseError response = new ResponseError();
        response.setRequestId(exception.getRequestId());
        response.setHostId(exception.getHostId());
        response.setErrCode(exception.getErrCode());
        response.setMessage(exception.getMessage());
        this.logger.debug("error response:" + response.toString(), (Throwable)exception);
        return response;
    }

    public void saveLog(ApiException exception) {
    }

    public void saveLog(AuthException exception) {
    }
}

