/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.restful.exception.handler;

import com.xdja.cssp.restful.auth.exception.AuthException;
import com.xdja.cssp.restful.bean.ResponseError;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class AuthExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(AuthExceptionHandler.class);

    @ExceptionHandler(value={AuthException.class})
    @ResponseBody
    public Object handleAuthException(AuthException exception, HttpServletResponse httpservletResponse) {
        httpservletResponse.setStatus(exception.getStatus());
        return this.convertError(exception);
    }

    public ResponseError convertError(AuthException exception) {
        ResponseError response = new ResponseError();
        response.setRequestId(exception.getRequestId());
        response.setHostId(exception.getHostId());
        response.setErrCode(exception.getErrCode());
        response.setMessage(exception.getMessage());
        this.logger.debug("error response:" + response.toString(), (Throwable)exception);
        return response;
    }
}

