package com.xdja.cssp.restful.bean;

import java.io.Serializable;
import java.security.PublicKey;

/**
 * 
 * @Description：请求对象
 * @author: yk
 * @date: 2015-5-6 10:51:03
 *
 */
public class Request implements Serializable {

	private static final long serialVersionUID = -7648927214411849251L;

	/**
	 * 请求id
	 */
	private String id;

	/**
	 * 安通账号
	 */
	private String account;
	
	/**
	 * 设备卡号
	 */
	private String cardNo;
	
	/**
	 * 客户端加密证书dn
	 */
	private String clientEncDN;

	/**
	 * 客户端加密证书sn
	 */
	private String clientEncSN;
	
	/**
	 * 客户端加密证书公钥
	 */
	private PublicKey clientEncPublicKey;

	/**
	 * 服务器证书dn
	 */
	private String serverDN;
	
	/**
	 * 服务器证书sn
	 */
	private String serverSN;
	
	/**
	 * 会话密钥加密算法
	 */
	private String keyAlgo;

	/**
	 * 数据加密算法
	 */
	private String contentAlgo;
	
	/**
	 * 签名算法
	 */
	private String signatureAlgo;
	
	/**
	 * 请求方法
	 */
	private String method;
	
	/**
	 * 请求uri
	 */
	private String uri;
	
	/**
	 * 会话密钥
	 */
	private String key;
	
	/**
	 * 请求数据
	 */
	private byte[] body;
	
	/**
	 * 请求数据转换为字符串
	 */
	private String content;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
	
	public String getAccount() {
		return account;
	}

	public void setAccount(String account) {
		this.account = account;
	}

	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}
	
	public String getClientEncDN() {
		return clientEncDN;
	}

	public void setClientEncDN(String clientEncDN) {
		this.clientEncDN = clientEncDN;
	}

	public String getClientEncSN() {
		return clientEncSN;
	}

	public void setClientEncSN(String clientEncSN) {
		this.clientEncSN = clientEncSN;
	}
	
	public PublicKey getClientEncPublicKey() {
		return clientEncPublicKey;
	}

	public void setClientEncPublicKey(PublicKey clientEncPublicKey) {
		this.clientEncPublicKey = clientEncPublicKey;
	}
	
	public String getServerDN() {
		return serverDN;
	}

	public void setServerDN(String serverDN) {
		this.serverDN = serverDN;
	}

	public String getServerSN() {
		return serverSN;
	}

	public void setServerSN(String serverSN) {
		this.serverSN = serverSN;
	}
	
	public String getKeyAlgo() {
		return keyAlgo;
	}

	public void setKeyAlgo(String keyAlgo) {
		this.keyAlgo = keyAlgo;
	}

	public String getContentAlgo() {
		return contentAlgo;
	}

	public void setContentAlgo(String contentAlgo) {
		this.contentAlgo = contentAlgo;
	}
	
	public String getSignatureAlgo() {
		return signatureAlgo;
	}

	public void setSignatureAlgo(String signatureAlgo) {
		this.signatureAlgo = signatureAlgo;
	}
	
	public String getMethod() {
		return method;
	}

	public void setMethod(String method) {
		this.method = method;
	}

	public String getUri() {
		return uri;
	}

	public void setUri(String uri) {
		this.uri = uri;
	}
	
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public byte[] getBody() {
		return body;
	}

	public void setBody(byte[] body) {
		this.body = body;
	}
	
	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
}
