package com.xdja.cssp.restful.exception;

import org.springframework.http.HttpStatus;

/**
 * 服务器内部异常
 * Http状态码 500
 * @author zhouyj
 *
 */
public class InternalServerException extends ApiException {
	


	private HttpStatus HTTP_STATUS = HttpStatus.INTERNAL_SERVER_ERROR;
	
	

	/**
	 * 
	 */
	private static final long serialVersionUID = -2210690833387511415L;


	public InternalServerException(String hostId, String requestId,
			String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	
	public InternalServerException(String hostId, String requestId,
			String errCode, String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}


	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}

}
