package com.xdja.cssp.restful.exception;

import org.springframework.http.HttpStatus;


/**
 * 资源冲突异常
 * <br>Http状态码 409
 * @author zhouyj
 *
 */
public class ResourceConflictException extends ApiException {
	


	public static final HttpStatus HTTP_STATUS = HttpStatus.CONFLICT;

	/**
	 * 
	 */
	private static final long serialVersionUID = 5860663130437638065L;
	
	
	
	public ResourceConflictException(String hostId, String requestId,
			String errCode, String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}


	public ResourceConflictException(String hostId, String requestId,
			String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	
	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}
	
	
	
	
}
