/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fprocessorClient.main;

import com.xdja.fprocessorClient.common.Utils;
import com.xdja.fprocessorClient.main.Result;
import com.xdja.fprocessorClient.rpcstubpool.RpcClientInfo;
import com.xdja.fprocessorClient.rpcstubpool.RpcStubPool;
import com.xdja.fprocessorClient.rpcstubpool.RpcStubPoolConfig;
import com.xdja.fprocessorClient.rpcstubpool.RpcStubPoolFactory;
import com.xdja.fprocessorClient.thriftstub.ConverterStub;
import com.xdja.thrift.datatype.ResBytes;
import com.xdja.thrift.datatype.ResStr;
import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FProcessorClient {
    private static Logger logger = LoggerFactory.getLogger(FProcessorClient.class);
    private RpcStubPoolFactory rpcfactory = null;
    private RpcStubPool rpcstubpool = null;
    private RpcStubPoolConfig config = new RpcStubPoolConfig();
    private int timeout;
    private int serverMode = 3;
    private String sHost = "";
    private int sPort = -1;

    public FProcessorClient(String serverHost, int serverPort) {
        this.sHost = serverHost;
        this.sPort = serverPort;
        this.config.setMaxActive(100);
        this.config.setMaxIdle(100);
        this.config.setMaxWait(3000L);
        this.config.setTestWhileIdle(false);
        this.config.setMinEvictableIdleTimeMillis(3600000L);
        this.config.setTestOnBorrow(true);
        this.config.setTestOnReturn(false);
    }

    public FProcessorClient(String serverHost, int serverPort, int timeout) {
        this.sHost = serverHost;
        this.sPort = serverPort;
        this.timeout = timeout;
        this.config.setMaxActive(100);
        this.config.setMaxIdle(100);
        this.config.setMaxWait(3000L);
        this.config.setTestWhileIdle(false);
        this.config.setMinEvictableIdleTimeMillis(3600000L);
        this.config.setTestOnBorrow(true);
        this.config.setTestOnReturn(false);
    }

    public FProcessorClient(String serverHost, int serverPort, int serverMode, RpcStubPoolConfig config, int timeout) {
        this.timeout = timeout;
        this.config = config;
        this.serverMode = serverMode;
        this.sHost = serverHost;
        this.sPort = serverPort;
    }

    public boolean init(long reqId) {
        String logFlag = "FProcessorClient.init";
        logger.info("[lid:{}][{}] serverHost:{} serverPort:{} serverMode:{}", new Object[]{reqId, logFlag, this.sHost, this.sPort, this.serverMode});
        this.rpcfactory = new RpcStubPoolFactory(this.sHost, this.sPort, this.serverMode, this.timeout);
        this.rpcstubpool = new RpcStubPool();
        if (!this.rpcstubpool.init(reqId, this.config, this.rpcfactory)) {
            logger.error("[lid:{}]  rpcpool init failed!", (Object)reqId);
            return false;
        }
        return true;
    }

    private <T> RpcClientInfo<T> getServiceClient(long reqId, String key) {
        String logFlag = "FProcessorClient.getServiceClient";
        Object rpcconnect = null;
        try {
            rpcconnect = this.rpcstubpool.getResource(reqId, key);
            return (RpcClientInfo)rpcconnect;
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{reqId, logFlag, Utils.getStackTrace(e)});
            this.rpcstubpool.returnBrokenResource(reqId, key, rpcconnect);
            return null;
        }
    }

    public Result<String> addPDFConversionTask(long logIndex, String caller, long srourceFileId, String srourceFilePath, String srourceFileType, String ext) {
        String logFlag = "FProcessorClient.addPDFConversionTask";
        RpcClientInfo ci = null;
        ResStr res = new ResStr();
        try {
            ci = this.getServiceClient(logIndex, "converterOperate");
            if (ci == null) {
                logger.warn("[lid:{}][{}] cann't get contact rpc Client", (Object)logIndex, (Object)logFlag);
                return new Result<Object>(553, null);
            }
            res = ((ConverterStub.Client)ci.getClient()).addPDFConversionTask(logIndex, caller, srourceFileId, srourceFilePath, srourceFileType, ext);
            if (res.res == 200) {
                logger.info("[lid:{}][{}] result:{}, value:{}", new Object[]{logIndex, logFlag, res.res, res.value});
            } else {
                logger.warn("[lid:{}][{}] failed! errcode:{}", new Object[]{logIndex, logFlag, res.res});
            }
            this.rpcstubpool.returnResource(logIndex, "converterOperate", ci);
            return new Result<String>(res.res, res.value, res.ext);
        }
        catch (TException e) {
            this.rpcstubpool.returnBrokenResource(logIndex, "converterOperate", ci);
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, Utils.getStackTrace(e)});
            return new Result<Object>(553, null);
        }
    }

    public Result<String> addThumbConvertTask(long logIndex, String caller, String blockJson, String suffix, String fileId, String ext) {
        String logFlag = "FProcessorClient.addThumbConvertTask";
        RpcClientInfo ci = null;
        ResStr res = new ResStr();
        try {
            ci = this.getServiceClient(logIndex, "converterOperate");
            if (ci == null) {
                logger.warn("[lid:{}][{}] cann't get contact rpc Client", (Object)logIndex, (Object)logFlag);
                return new Result<Object>(553, null);
            }
            res = ((ConverterStub.Client)ci.getClient()).addImageThumbConvertTask(logIndex, caller, blockJson, suffix, fileId, ext);
            if (res.res == 200) {
                logger.info("[lid:{}][{}] result:{}, value:{}", new Object[]{logIndex, logFlag, res.res, res.value});
            } else {
                logger.warn("[lid:{}][{}] failed! errcode:{}", new Object[]{logIndex, logFlag, res.res});
            }
            this.rpcstubpool.returnResource(logIndex, "converterOperate", ci);
            return new Result<String>(res.res, res.value, res.ext);
        }
        catch (TException e) {
            this.rpcstubpool.returnBrokenResource(logIndex, "converterOperate", ci);
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, Utils.getStackTrace(e)});
            return new Result<Object>(553, null);
        }
    }

    public Result<byte[]> getThumImage(long logIndex, String caller, long userId, String fileId, String width, String height, String extractedCode, String thumbnailLevel, String waterMark, String scaleFactor, String suffix, String ext) {
        String logFlag = "FProcessorClient.getThumImage";
        RpcClientInfo ci = null;
        ResBytes res = null;
        try {
            ci = this.getServiceClient(logIndex, "converterOperate");
            if (ci == null) {
                logger.warn("[lid:{}][{}] cann't get contact rpc Client", (Object)logIndex, (Object)logFlag);
                return new Result<Object>(553, null);
            }
            res = ((ConverterStub.Client)ci.getClient()).getThumImage(logIndex, caller, userId, fileId, width, height, extractedCode, thumbnailLevel, waterMark, scaleFactor, suffix, ext);
            if (res.res == 200) {
                logger.info("[lid:{}][{}] result:{}, value:{}", new Object[]{logIndex, logFlag, res.res, res.value});
            } else {
                logger.warn("[lid:{}][{}] failed! errcode:{}", new Object[]{logIndex, logFlag, res.res});
            }
            this.rpcstubpool.returnResource(logIndex, "converterOperate", ci);
            return new Result<byte[]>(res.res, this.convert(res.value), res.ext);
        }
        catch (TException e) {
            this.rpcstubpool.returnBrokenResource(logIndex, "converterOperate", ci);
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{logIndex, logFlag, Utils.getStackTrace(e)});
            return new Result<Object>(553, null);
        }
    }

    public void shutDown(long reqId) {
        String logFlag = "FProcessorClient.shutDown";
        if (this.rpcstubpool == null) {
            return;
        }
        try {
            this.rpcstubpool.destroy(reqId);
            this.rpcstubpool = null;
        }
        catch (Exception ex) {
            logger.error("[lid:{}][{}]exception happened while shutting down rpcstubpool...", (Object)reqId, (Object)logFlag);
        }
    }

    private byte[] convert(ByteBuffer byteBuffer) {
        int len = byteBuffer.limit() - byteBuffer.position();
        byte[] bytes = new byte[len];
        if (byteBuffer.isReadOnly()) {
            return null;
        }
        byteBuffer.get(bytes);
        return bytes;
    }
}

