/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fprocessorClient.rpcstubpool;

import com.xdja.fprocessorClient.rpcstubpool.RpcStubPoolFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcStubPool {
    protected GenericKeyedObjectPool<String, Object> internalPool;
    public AtomicInteger logId = new AtomicInteger(-1);
    public static AtomicInteger iNum = new AtomicInteger(0);
    private static Logger logger = LoggerFactory.getLogger(RpcStubPool.class);
    private AtomicBoolean isInit = new AtomicBoolean(false);

    private boolean isInit() {
        return this.isInit.get();
    }

    private String getClassName() {
        return "RpcStubPool";
    }

    public boolean init(long logIndex, GenericKeyedObjectPool.Config poolConfig, RpcStubPoolFactory factory) {
        this.isInit.set(true);
        String logFlag = this.getClassName() + ".init";
        if (this.internalPool != null) {
            try {
                this.destroy(logIndex);
            }
            catch (Exception e) {
                logger.warn("[lid:{}][{}]resource is null! Exception detail:{}", new Object[]{logIndex, logFlag, e});
                return false;
            }
        }
        this.internalPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)factory, poolConfig);
        return this.internalPool != null;
    }

    public void destroy(long logIndex) {
        String logFlag = this.getClassName() + ".destroy";
        if (!this.isInit()) {
            logger.warn("[lid:{}][{}]rpcpool is not init", (Object)logIndex, (Object)logFlag);
            return;
        }
        try {
            this.internalPool.close();
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}]destory failed! Exception detail:{}", new Object[]{logIndex, logFlag, e});
        }
    }

    public Object getResource(long logIndex, String key) {
        String logFlag = this.getClassName() + ".getResource";
        if (!this.isInit()) {
            logger.warn("[lid:{}][{}]rpcpool is not init", (Object)logIndex, (Object)logFlag);
            return null;
        }
        Object res = null;
        try {
            res = this.internalPool.borrowObject((Object)key);
            return res;
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}]Could not get a resource from the pool! Exception detail:{}", new Object[]{logIndex, logFlag, e});
            this.returnBrokenResource(logIndex, key, res);
            return null;
        }
    }

    public void returnBrokenResource(long logIndex, String key, Object resource) {
        String logFlag = this.getClassName() + ".returnBrokenResource";
        if (!this.isInit()) {
            logger.warn("[lid:{}][{}]rpcpool is not init", (Object)logIndex, (Object)logFlag);
            return;
        }
        if (resource == null) {
            logger.warn("[lid:{}][{}]resource is null!", (Object)logIndex, (Object)logFlag);
            return;
        }
        try {
            this.internalPool.invalidateObject((Object)key, resource);
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}]invalidateObject failed!  Exception detail:{}", new Object[]{logIndex, logFlag, e});
        }
    }

    public void returnResource(long logIndex, String key, Object resource) {
        String logFlag = this.getClassName() + ".returnResource";
        if (!this.isInit()) {
            logger.warn("[lid:{}][{}]rpcpool is not init", (Object)logIndex, (Object)logFlag);
            return;
        }
        if (resource == null) {
            logger.warn("[lid:{}][{}]resource is null!", (Object)logIndex, (Object)logFlag);
            return;
        }
        try {
            this.internalPool.returnObject((Object)key, resource);
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}]returnObject failed!  Exception detail:{}", new Object[]{logIndex, logFlag, e});
        }
    }
}

