/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fprocessorClient.rpcstubpool;

import com.xdja.fprocessorClient.common.DefaultValues;
import com.xdja.fprocessorClient.rpcstubpool.RpcClientInfo;
import com.xdja.fprocessorClient.rpcstubpool.RpcStubPool;
import com.xdja.fprocessorClient.thriftstub.ConverterStub;
import com.xdja.thrift.datatype.ResStr;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcStubPoolFactory
extends BaseKeyedPoolableObjectFactory<String, Object> {
    private final String host;
    private final int port;
    private final int serverMode;
    private final int timeout;
    public AtomicInteger logId = new AtomicInteger(-1);
    private static Logger logger = LoggerFactory.getLogger(RpcStubPoolFactory.class);

    private String getClassName() {
        return "RpcStubPoolFactory";
    }

    public RpcStubPoolFactory(String host, int port, int mode, int timeout) {
        this.host = host;
        this.port = port;
        this.serverMode = mode;
        this.timeout = timeout;
    }

    public boolean checkSocket(Socket socket) {
        return socket != null && socket.isBound() && !socket.isClosed() && socket.isConnected() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }

    public Object makeObject(String key) throws Exception {
        String logFlag = this.getClassName() + ".makeObject";
        TSocket transport = null;
        TBinaryProtocol protocol = null;
        TSocket tsocket = null;
        if (this.serverMode == DefaultValues.SERVER_MODE_THREAD_POOL) {
            transport = tsocket = new TSocket(this.host, this.port, this.timeout);
            protocol = new TBinaryProtocol((TTransport)transport);
        } else if (this.serverMode == DefaultValues.SERVER_MODE_NONBLOCK || this.serverMode == DefaultValues.SERVER_MODE_THREADEDSELECTOR) {
            tsocket = new TSocket(this.host, this.port, this.timeout);
            transport = new TFramedTransport((TTransport)tsocket);
            protocol = new TBinaryProtocol((TTransport)transport);
        }
        TMultiplexedProtocol multiPro = new TMultiplexedProtocol(protocol, key);
        try {
            RpcClientInfo<ConverterStub.Client> rpctype = null;
            switch (key) {
                case "converterOperate": {
                    rpctype = new RpcClientInfo<ConverterStub.Client>(new ConverterStub.Client((TProtocol)multiPro), (TTransport)transport, tsocket);
                    rpctype.getTTransport().open();
                    break;
                }
            }
            return rpctype;
        }
        catch (TTransportException e) {
            logger.warn("[lid:{}][{}]getTTransport failed! TTransportException detail: {}", new Object[]{this.logId.getAndDecrement(), logFlag, e});
            return null;
        }
    }

    public boolean validateObject(String key, Object obj) {
        String logFlag = this.getClassName() + ".validateObject";
        this.logId.getAndIncrement();
        if (obj == null) {
            logger.warn("[lid:{}][{}]Object is empty!", (Object)this.logId.get(), (Object)logFlag);
            return false;
        }
        ResStr resStr = null;
        try {
            switch (key) {
                case "converterOperate": {
                    RpcClientInfo rpcec = (RpcClientInfo)obj;
                    if (!this.checkSocket(rpcec.getTSocket().getSocket())) {
                        logger.warn("[lid:{}][{}] checkSocket fail!", (Object)this.logId.get(), (Object)logFlag);
                        return false;
                    }
                    this.logId.getAndIncrement();
                    resStr = ((ConverterStub.Client)rpcec.getClient()).echo(this.logId.longValue(), logFlag, "ok");
                    if (resStr.res != 200) {
                        logger.warn("[lid:{}][{}] err result!", (Object)this.logId.get(), (Object)logFlag);
                        return false;
                    }
                    return resStr.value.equals("ok");
                }
            }
            return super.validateObject((Object)key, obj);
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}]validateObject fail! Exception detail:{}", new Object[]{this.logId.get(), logFlag, e});
            return false;
        }
    }

    public void destroyObject(String key, Object obj) throws Exception {
        String logFlag = this.getClassName() + ".destroyObject";
        if (obj == null) {
            logger.warn("[lid:{}][{}]Object is empty!", (Object)this.logId.getAndDecrement(), (Object)logFlag);
            return;
        }
        switch (key) {
            case "converterOperate": {
                RpcClientInfo rpcec = (RpcClientInfo)obj;
                rpcec.getTTransport().close();
                break;
            }
        }
        RpcStubPool.iNum.decrementAndGet();
    }
}

