/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.generated.dao;

import com.xdja.platform.datacenter.service.DataCenterService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class GeneratedDao {
    @Autowired
    private DataCenterService dssevService;
    private static final Logger Log = LoggerFactory.getLogger(GeneratedDao.class);
    private static final String CREATE_ID = "INSERT INTO t_generated_id (n_update_serial, c_serial_type,n_block_size) VALUES (1, :keyType,:blockSize)";
    private static final String LOAD_ID = "SELECT n_update_serial,c_serial_type,n_block_size FROM t_generated_id WHERE c_serial_type=:type";
    private static final String UPDATE_ID = "UPDATE t_generated_id SET n_update_serial=:newId WHERE c_serial_type=:keyType";
    private static final String SELECT_SQL = "SELECT c_serial_type,n_block_size FROM t_generated_id ";

    public void createNewID(String type, Integer blockSize) {
        Log.warn("Autocreating jiveID row for type '" + type + "'");
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("keyType", (Object)type);
        parameterSource.addValue("blockSize", (Object)blockSize);
        this.dssevService.executeSql(CREATE_ID, (SqlParameterSource)parameterSource);
    }

    public Map<String, Object> loadId(String type) {
        return this.dssevService.queryForMap(LOAD_ID, (SqlParameterSource)new MapSqlParameterSource().addValue("type", (Object)type));
    }

    public Integer updateNextBlock(Long newId, String type) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("newId", (Object)newId);
        parameterSource.addValue("keyType", (Object)type);
        return this.dssevService.executeSql(UPDATE_ID, (SqlParameterSource)parameterSource);
    }

    public List<Map<String, Object>> queryGenerated() {
        return this.dssevService.queryForList(SELECT_SQL, (SqlParameterSource)new MapSqlParameterSource());
    }
}

