/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.generated.operator;

import com.xdja.cssp.generated.business.IGeneratedBusiness;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceManager {
    private static Logger Log = LoggerFactory.getLogger(SequenceManager.class);
    private static Map<String, SequenceManager> managers = new ConcurrentHashMap<String, SequenceManager>();
    private static IGeneratedBusiness business;
    private String type;
    private long currentID;
    private long maxID;
    private int blockSize;
    private boolean success;

    public static long nextID(String type) {
        if (managers.containsKey(type)) {
            return managers.get(type).nextUniqueID();
        }
        SequenceManager manager = new SequenceManager(type, 1, business);
        return manager.nextUniqueID();
    }

    public static void setBlockSize(String type, int blockSize, IGeneratedBusiness business) {
        if (managers.containsKey(type)) {
            SequenceManager.managers.get((Object)type).blockSize = blockSize;
        } else {
            new SequenceManager(type, blockSize, business);
        }
    }

    public SequenceManager(String seqType, int size, IGeneratedBusiness business) {
        managers.put(seqType, this);
        this.type = seqType;
        this.blockSize = size;
        this.currentID = 0L;
        this.maxID = 0L;
        SequenceManager.business = business;
    }

    public synchronized long nextUniqueID() {
        if (this.currentID >= this.maxID) {
            this.getNextBlock();
        }
        long id = this.currentID++;
        return id;
    }

    private void getNextBlock() {
        try {
            Map<String, Object> data = business.loadId(this.type);
            if (data == null) {
                business.createNewID(this.type, Integer.parseInt(data.get("n_block_size") == null ? "10" : data.get("n_block_size").toString()));
            } else {
                this.currentID = Integer.parseInt(data.get("n_update_serial").toString());
                this.blockSize = Integer.parseInt(data.get("n_block_size").toString());
            }
            long newID = this.currentID + (long)this.blockSize;
            int result = business.updateNextBlock(newID, this.type);
            boolean bl = this.success = result == 1;
            if (this.success) {
                this.currentID = this.currentID;
                this.maxID = newID;
            }
        }
        catch (Exception e) {
            Log.error("\u66f4\u65b0\u51fa\u9519\uff1a", (Throwable)e);
        }
        if (!this.success) {
            Log.error("WARNING: failed to obtain next ID block due to thread contention. Trying again...");
            try {
                Thread.sleep(75L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

