/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.generated.service.core.microservice;

import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.microservice.config.MicroServiceConfig;
import com.xdja.platform.microservice.plugin.IPlugin;
import com.xdja.platform.microservice.plugin.Plugins;
import com.xdja.platform.microservice.spring.SpringPlugin;
import com.xdja.platform.rpc.provider.ProviderStarter;
import com.xdja.platform.rpc.proxy.PagingConverter;
import java.net.BindException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Config
extends MicroServiceConfig {
    private Logger logger = LoggerFactory.getLogger(Config.class);
    public static final String IP = "127.0.0.1";
    public static final int PORT = 6666;
    public static final int MAXWORKTHREAD = 5000;

    public void configPlugin(Plugins plugins) {
        String[] configLocations = new String[]{"classpath*:/META-INF/spring/applicationContext-*.xml", "classpath*:/applicationContext.xml"};
        ClassPathXmlApplicationContext ac = new ClassPathXmlApplicationContext(configLocations);
        plugins.add((IPlugin)new SpringPlugin((ApplicationContext)ac));
    }

    public void afterStart() {
        PagingConverter.pageNoMethodName = "getPageNo";
        PagingConverter.pageSizeMethodName = "getPageSize";
        PagingConverter.totalCountMethodName = "getTotalCount";
        PagingConverter.totalPageMethodName = "getTotalPage";
        PagingConverter.dataListMethodName = "getList";
        Prop prop = PropKit.use((String)"service.properties");
        String ip = prop.get("ip", IP);
        int port = prop.getInt("port", Integer.valueOf(6666));
        int maxWorkThread = prop.getInt("maxWorkThread", Integer.valueOf(5000));
        try {
            ProviderStarter.NETTY.setMaxWorkThread(maxWorkThread).start(ip, port);
            this.logger.debug("=================>Generated-Key \u670d\u52a1\u542f\u52a8\u6210\u529f\uff01\u670d\u52a1\u5730\u5740:{}:{},\u6700\u5927\u5de5\u4f5c\u7ebf\u7a0b\u6570{}", new Object[]{ip, port, maxWorkThread});
        }
        catch (BindException e) {
            this.logger.error("\u670d\u52a1\u7ed1\u5b9a\u5f02\u5e38", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.logger.error("\u7ebf\u7a0b\u5f02\u5e38", (Throwable)e);
        }
    }
}

