package com.xdja.cssp.key.server.api;

import java.util.List;
import java.util.Map;

import com.xdja.cssp.key.server.api.bean.KsfBean;
import com.xdja.cssp.key.server.api.bean.ResultKsfBean;
import com.xdja.cssp.key.server.exception.ServiceException;
import com.xdja.platform.rpc.RemoteService;

/**
 * 
 * Project Name：key-server-api
 * ClassName：IKsfService
 * Description：ksf RPC接口定义
 * @author: 谢文超
 * @date: 2015-7-10 上午11:38:34
 * note:
 * 
 */
@RemoteService(serviceCode = "key")
public interface IKsfService {

	/**
	 * 
	 * 方法描述：查询与指定账号间的会话密钥
	 * @author: 谢文超
	 * @date: 2015-7-10 上午11:40:59
	 * @param account 当前账号
	 * @param friendAccounts 好友账号列表
	 * @return
	 * @throws IllegalArgumentException 参数错误异常
	 */
	Map<String/*好友帐号*/, ResultKsfBean/*该帐号对应的ksf信息*/> queryAccountKsfs(String account, List<String> friendAccounts) throws IllegalArgumentException;
	
	/**
	 * 方法描述：查询指定Id的账号间会话密钥
	 * @author 谢文超
	 * @date 2015-7-10 上午11:41:08
	 * @param account 当前账号
	 * @param ksfId ksfId
	 * @return
	 * @throws IllegalArgumentException 参数错误异常
	 */
	ResultKsfBean queryKsfById(String account, String ksfId) throws IllegalArgumentException;
	
	/**
	 * 好友ksf上传
	 * @author 马德成
	 * @date 2015年7月13日
	 * @param ksfBean ksf信息
	 * @return
	 * @throws IllegalArgumentException 参数错误异常
	 * @throws ServiceException 好友帐号和kuepId不对应时会抛出此异常
	 */
	ResultKsfBean uploadKsf(KsfBean ksfBean) throws IllegalArgumentException, ServiceException;
}
