package com.xdja.cssp.key.server.api;

import java.util.List;
import java.util.Map;

import com.xdja.cssp.key.server.api.bean.KsgAlgBean;
import com.xdja.cssp.key.server.api.bean.KsgResultBean;
import com.xdja.cssp.key.server.api.bean.UploadKsgBean;
import com.xdja.cssp.key.server.exception.ServiceException;
import com.xdja.platform.rpc.RemoteService;

/**
 * 群成员ksg接口
 * Project Name：key-server-api
 * ClassName：IKsgService
 * @author: fy
 * @date: 2015-7-13 上午10:15:38
 * note:
 *
 */
@RemoteService(serviceCode="key")
public interface IKsgService {

	/**
	 * 
	 * 方法描述： 方法描述：群成员上传接口
	 * @author: fy
	 * @date: 2015-7-18 上午10:25:46
	 * @param uploadKsgBean
	 * @return
	 * @throws IllegalArgumentException 参数异常
	 * @throws ServiceException 此群组密钥信息已存在
	 */
	public KsgResultBean uploadKsg(UploadKsgBean uploadKsgBean) throws IllegalArgumentException,ServiceException;
	
	/**
	 * 
	 * 方法描述：群成员Ksg上传接口
	 * @author: fy
	 * @date: 2015-7-18 上午10:26:15
	 * @param ksgAlgBean
	 * @throws IllegalArgumentException 参数异常
	 * @throws ServiceException 此群组密钥信息不存在
	 */
	public void uploadMemberKsg(KsgAlgBean ksgAlgBean) throws IllegalArgumentException,ServiceException;

	/**
	 * 
	 * 方法描述：群成员Ksg删除接口
	 * @author: fy
	 * @date: 2015-7-13 上午10:55:39
	 * @param ksgId
	 * @param accounts
	 * @throws IllegalArgumentException 参数异常
	 * @return
	 */
	public void delMemberKsg(String ksgId, List<String> accounts) throws IllegalArgumentException;

	/**
	 * 
	 * 方法描述：账户Ksf查询接口
	 * @author: fy
	 * @date: 2015-7-13 上午11:23:00
	 * @param account
	 * @throws IllegalArgumentException 参数异常
	 * @return
	 */
	public Map<Long, KsgResultBean> queryAccountKsgs(String account, List<Long> groupIds) throws IllegalArgumentException;
}
