/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.asset.action;

import com.xdja.cssp.ams.assetmanager.entity.AssetCondition;
import com.xdja.cssp.ams.assetmanager.entity.AssetDetails;
import com.xdja.cssp.ams.assetmanager.service.IAssetInfoService;
import com.xdja.cssp.ams.web.json.DataTablesParameters;
import com.xdja.cssp.ams.web.system.action.DicInitCache;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.web.action.BaseAction;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AssetInfoAction
extends BaseAction {
    IAssetInfoService assetInfoService = (IAssetInfoService)DefaultServiceRefer.getServiceRefer(IAssetInfoService.class);

    @RequestMapping(value={"/asset/info/index.do"})
    public String Index(ModelMap modelMap) {
        modelMap.addAttribute("assetType", (Object)DicInitCache.getDics((String)"assetType"));
        modelMap.addAttribute("assetTypeStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"assetType")));
        return "asset/info/index";
    }

    @RequestMapping(value={"/asset/info/ajaxList.do"})
    @ResponseBody
    public Object ajaxList(AssetCondition condition) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "", "assetType", "", "", "", "time", ""};
        LitePaging pagination = this.assetInfoService.queryAllAssets(condition, tables.getPage(), tables.getLength(), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/asset/info/getAssetInfo.do"})
    public String getAssetInfo(String id, ModelMap modelMap) {
        AssetDetails detail = this.assetInfoService.getAssetInfo(Long.valueOf(id));
        detail.setAssetType((String)DicInitCache.getDics((String)"assetType").get(detail.getAssetType()));
        modelMap.addAttribute("detail", (Object)detail);
        return "asset/info/detail";
    }

    @RequestMapping(value={"/asset/info/editActivateInfo.do"})
    public String editActivateInfo(String assetId, ModelMap modelMap) {
        AssetDetails asset = this.assetInfoService.getAssetInfo(Long.valueOf(assetId));
        modelMap.addAttribute("activateAllow", (Object)asset.getIsAllowedActivate());
        modelMap.addAttribute("asset", (Object)asset);
        return "asset/info/edit";
    }

    @RequestMapping(value={"/asset/info/saveActivateInfo.do"})
    public void saveActivateInfo(AssetDetails condition, HttpServletResponse response) {
        String message = "success";
        try {
            this.assetInfoService.modifyActivateInfo(condition);
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u8d44\u4ea7\u6fc0\u6d3b\u4fe1\u606f\u4fdd\u5b58\u65f6\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u4fdd\u5b58\u8d44\u4ea7\u6fc0\u6d3b\u4fe1\u606f\u5931\u8d25";
            this.logger.error("\u4fdd\u5b58\u8d44\u4ea7\u6fc0\u6d3b\u4fe1\u606f\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (Throwable)e);
        }
        this.renderText(response, message);
    }
}

