/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.json;

import com.xdja.cssp.ams.web.json.DataTablesReply;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DataTablesParameters {
    private int start;
    private int length;
    private int orderCol;
    private String orderDir;
    private int draw;
    private HttpServletRequest request;

    public DataTablesParameters() {
        this(((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest());
    }

    public static DataTablesParameters newInstance() {
        return new DataTablesParameters();
    }

    public DataTablesParameters(HttpServletRequest request) {
        this.request = request;
        this.start = Integer.parseInt(request.getParameter("start"));
        this.length = Integer.parseInt(request.getParameter("length"));
        String orderColumn = request.getParameter("order[0][column]");
        if (StringUtils.isNotBlank((CharSequence)orderColumn)) {
            this.orderCol = Integer.parseInt(orderColumn);
            this.orderCol = this.orderCol < 0 ? 0 : this.orderCol;
        } else {
            this.orderCol = 9999999;
        }
        String dir = request.getParameter("order[0][dir]");
        if (StringUtils.isNotBlank((CharSequence)dir)) {
            this.orderDir = dir.trim().toUpperCase();
            if (!this.orderDir.equals("ASC") && !this.orderDir.equals("DESC")) {
                this.orderDir = "ASC";
            }
        } else {
            this.orderDir = "ASC";
        }
        this.draw = Integer.parseInt(request.getParameter("draw"));
    }

    public DataTablesReply<?> getDataTablesReply(LitePaging<?> pagination) {
        return new DataTablesReply(pagination, this.getDraw());
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getDraw() {
        return this.draw;
    }

    public void setDraw(int draw) {
        this.draw = draw;
    }

    public int getOrderCol() {
        return this.orderCol;
    }

    public void setOrderCol(int orderCol) {
        this.orderCol = orderCol;
    }

    public String getOrderDir() {
        return this.orderDir;
    }

    public void setOrderDir(String orderDir) {
        this.orderDir = orderDir;
    }

    public int getPage() {
        return this.start / this.length + 1;
    }

    public String getOrderColName(String[] orderColumns) {
        return this.orderCol < orderColumns.length ? orderColumns[this.orderCol] : null;
    }

    public String getOrderColName() {
        return this.request.getParameter("columns[" + this.orderCol + "][data]");
    }
}

