/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.util;

import com.xdja.cssp.ams.assetmanager.entity.ExcelCell;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelUtil {
    public static void getExcel(OutputStream output, String sheetName, List<?> dates, boolean hasIndexColume) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        HSSFRow row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft((short)1);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop((short)1);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
        cellStyleWithDate.setAlignment((short)2);
        cellStyleWithDate.setVerticalAlignment((short)1);
        cellStyleWithDate.setBorderBottom((short)1);
        cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderLeft((short)1);
        cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderRight((short)1);
        cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderTop((short)1);
        cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        HSSFCellStyle cellStyleHead = wb.createCellStyle();
        cellStyleHead.setAlignment((short)2);
        cellStyleHead.setVerticalAlignment((short)1);
        cellStyleHead.setBorderBottom((short)6);
        cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderLeft((short)1);
        cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderRight((short)1);
        cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderTop((short)1);
        cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyleHead.setFillPattern((short)1);
        HSSFCell fields = dates.get(0).getClass().getDeclaredFields();
        int x = 0;
        if (hasIndexColume) {
            HSSFCell cell = row.createCell(x);
            cell.setCellStyle((CellStyle)cellStyleHead);
            cell.setCellValue("\u5e8f\u53f7");
            sheet.setColumnWidth(x, 2560);
            ++x;
        }
        for (HSSFCell field : fields) {
            ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
            if (null == excelCell) continue;
            HSSFCell cellHead = row.createCell(x);
            cellHead.setCellStyle((CellStyle)cellStyleHead);
            cellHead.setCellValue(excelCell.title());
            sheet.setColumnWidth(x, 256 * excelCell.width());
            ++x;
        }
        for (int i = 0; i < dates.size(); ++i) {
            row = sheet.createRow(1 + i);
            row.setHeightInPoints(20.0f);
            Object object = dates.get(i);
            int n = 0;
            if (hasIndexColume) {
                HSSFCell xh = row.createCell(0);
                xh.setCellStyle((CellStyle)cellStyle);
                xh.setCellValue((double)(i + 1));
                ++n;
            }
            for (Field field : object.getClass().getDeclaredFields()) {
                ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                if (null == excelCell) continue;
                field.setAccessible(true);
                HSSFCell data = row.createCell(n);
                if (excelCell.isDate()) {
                    if (null != field.get(object)) {
                        Date date = new Date(Long.parseLong(field.get(object).toString()));
                        data.setCellValue(date);
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    } else {
                        data.setCellValue("");
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    }
                } else {
                    if (field.get(object) != null) {
                        data.setCellValue(field.get(object).toString());
                    }
                    data.setCellStyle((CellStyle)cellStyle);
                }
                field.setAccessible(false);
                ++n;
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Output is closed");
        }
    }

    public static void getExcel(OutputStream output, String sheetName, String title, List<?> dates) throws Exception {
        Field[] fields;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft((short)1);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop((short)1);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFCellStyle cellStyleWithDate = wb.createCellStyle();
        cellStyleWithDate.setAlignment((short)2);
        cellStyleWithDate.setVerticalAlignment((short)1);
        cellStyleWithDate.setBorderBottom((short)1);
        cellStyleWithDate.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderLeft((short)1);
        cellStyleWithDate.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderRight((short)1);
        cellStyleWithDate.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setBorderTop((short)1);
        cellStyleWithDate.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleWithDate.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        HSSFCellStyle cellStyleHead = wb.createCellStyle();
        cellStyleHead.setAlignment((short)2);
        cellStyleHead.setVerticalAlignment((short)1);
        cellStyleHead.setBorderBottom((short)6);
        cellStyleHead.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderLeft((short)1);
        cellStyleHead.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderRight((short)1);
        cellStyleHead.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setBorderTop((short)1);
        cellStyleHead.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyleHead.setFillPattern((short)1);
        HSSFCellStyle cellStyleTitle = wb.createCellStyle();
        cellStyleTitle.setAlignment((short)2);
        cellStyleTitle.setVerticalAlignment((short)1);
        cellStyleTitle.setBorderBottom((short)1);
        cellStyleTitle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderLeft((short)1);
        cellStyleTitle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderRight((short)1);
        cellStyleTitle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleTitle.setBorderTop((short)1);
        cellStyleTitle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        HSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)13);
        cellStyleTitle.setFont((Font)font);
        HSSFRow row = sheet.createRow(0);
        row = sheet.createRow(1);
        row.setHeightInPoints(30.0f);
        int x = 0;
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle((CellStyle)cellStyleHead);
        cell.setCellValue("\u5e8f\u53f7");
        sheet.setColumnWidth(x, 2560);
        ++x;
        for (Field field : fields = dates.get(0).getClass().getDeclaredFields()) {
            ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
            if (null == excelCell) continue;
            HSSFCell cellHead = row.createCell(x);
            cellHead.setCellStyle((CellStyle)cellStyleHead);
            cellHead.setCellValue(excelCell.title());
            sheet.setColumnWidth(x, 256 * excelCell.width());
            ++x;
        }
        row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        HSSFCell titleCell = row.createCell(0);
        titleCell.setCellValue(title);
        titleCell.setCellStyle((CellStyle)cellStyleTitle);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, x - 1));
        for (int i = 0; i < dates.size(); ++i) {
            row = sheet.createRow(2 + i);
            row.setHeightInPoints(20.0f);
            Object object = dates.get(i);
            HSSFCell xh = row.createCell(0);
            xh.setCellStyle((CellStyle)cellStyle);
            xh.setCellValue((double)(i + 1));
            int n = 1;
            for (Field field : object.getClass().getDeclaredFields()) {
                ExcelCell excelCell = field.getAnnotation(ExcelCell.class);
                if (null == excelCell) continue;
                field.setAccessible(true);
                HSSFCell data = row.createCell(n);
                if (excelCell.isDate()) {
                    if (null != field.get(object)) {
                        Date date = new Date(Long.parseLong(field.get(object).toString()));
                        data.setCellValue(date);
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    } else {
                        data.setCellValue("");
                        data.setCellStyle((CellStyle)cellStyleWithDate);
                    }
                } else {
                    if (field.get(object) != null) {
                        data.setCellValue(field.get(object).toString());
                    }
                    data.setCellStyle((CellStyle)cellStyle);
                }
                field.setAccessible(false);
                ++n;
            }
        }
        try {
            output.flush();
            wb.write(output);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Output is closed");
        }
    }

    public static void ZipFiles(File[] srcfile, File zipfile) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));
            for (int i = 0; i < srcfile.length; ++i) {
                int len;
                FileInputStream in = new FileInputStream(srcfile[i]);
                out.putNextEntry(new ZipEntry(srcfile[i].getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

