/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.util;

import com.xdja.cssp.ams.assetmanager.entity.CertBean;
import com.xdja.cssp.ams.web.resolve.ResolveData;
import com.xdja.cssp.ams.web.resolve.XmlFactory;
import com.xdja.cssp.ams.web.util.CertUtil;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveCert {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, List<CertBean>> datas = new HashMap();

    public void resolve(InputStream in) throws Exception {
        this.logger.info("------\u5f00\u59cb\u89e3\u6790\u8bc1\u4e66\u6570\u636e\u6587\u4ef6----------");
        ResolveData resolve = XmlFactory.getResolveData();
        resolve.loadSourceFromFile(in);
        Element root = resolve.getRootElement();
        List rsaSingleCert = root.selectNodes("haveCert/rsa/single/card");
        this.resolveSingleCert(rsaSingleCert, 1);
        List rsaDoubleCert = root.selectNodes("haveCert/rsa/double/card");
        this.resolveDoubleCert(rsaDoubleCert, 1);
        List sm2SingleCert = root.selectNodes("haveCert/sm2/single/card");
        this.resolveSingleCert(sm2SingleCert, 2);
        List sm2DoubleCert = root.selectNodes("haveCert/sm2/double/card");
        this.resolveDoubleCert(sm2DoubleCert, 2);
        this.logger.info("------\u89e3\u6790\u8bc1\u4e66\u6570\u636e\u6587\u4ef6\u7ed3\u675f----------");
    }

    public void resolve(String fileName) throws Exception {
        this.logger.info("------\u5f00\u59cb\u89e3\u6790\u8bc1\u4e66\u6570\u636e\u6587\u4ef6----------");
        ResolveData resolve = XmlFactory.getResolveData();
        resolve.loadSourceFromFile(fileName);
        Element root = resolve.getRootElement();
        List rsaSingleCert = root.selectNodes("haveCert/rsa/single/card");
        this.resolveSingleCert(rsaSingleCert, 1);
        List rsaDoubleCert = root.selectNodes("haveCert/rsa/double/card");
        this.resolveDoubleCert(rsaDoubleCert, 1);
        List sm2SingleCert = root.selectNodes("haveCert/sm2/single/card");
        this.resolveSingleCert(sm2SingleCert, 2);
        List sm2DoubleCert = root.selectNodes("haveCert/sm2/double/card");
        this.resolveDoubleCert(sm2DoubleCert, 2);
        this.logger.info("------\u89e3\u6790\u8bc1\u4e66\u6570\u636e\u6587\u4ef6\u7ed3\u675f----------");
    }

    private void resolveSingleCert(List<Element> cardElement, int caAlg) {
        Element element = null;
        String cardNo = null;
        String cert = null;
        for (Element item : cardElement) {
            Iterator iterator = item.elementIterator();
            while (iterator.hasNext()) {
                element = (Element)iterator.next();
                if (element.getName().equalsIgnoreCase("cardNo")) {
                    cardNo = element.getText();
                }
                if (!element.getName().equalsIgnoreCase("cert")) continue;
                cert = element.getText();
            }
            this.constructSql(cardNo.toLowerCase(), caAlg, 3, cert);
        }
    }

    private void resolveDoubleCert(List<Element> cardElement, int caAlg) {
        Element element = null;
        String cardNo = null;
        String signCert = null;
        String encCert = null;
        for (Element item : cardElement) {
            try {
                Iterator iterator = item.elementIterator();
                while (iterator.hasNext()) {
                    element = (Element)iterator.next();
                    if (element.getName().equalsIgnoreCase("cardNo")) {
                        cardNo = element.getText();
                    }
                    if (element.getName().equalsIgnoreCase("signCert")) {
                        signCert = element.getText();
                    }
                    if (!element.getName().equalsIgnoreCase("encCert")) continue;
                    encCert = element.getText();
                }
                this.constructSql(cardNo.toLowerCase(), caAlg, 2, signCert);
                this.constructSql(cardNo.toLowerCase(), caAlg, 1, encCert);
            }
            catch (Exception e) {
                this.datas.put(cardNo, null);
                this.logger.error("\u89e3\u6790\u5361{}\u7684\u8bc1\u4e66\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a" + e.getMessage(), (Object)cardNo);
            }
        }
    }

    private void constructSql(String cardNo, int caAlg, int certType, String cert) {
        X509Certificate x509 = CertUtil.getCertFromStr((String)cert);
        CertBean certBean = new CertBean();
        List certList = (ArrayList)this.datas.get(cardNo);
        certList = certList != null && certList.size() > 0 ? (List)this.datas.get(cardNo) : new ArrayList();
        certBean.setCardNo(cardNo);
        certBean.setSn(CertUtil.getSn((X509Certificate)x509));
        certBean.setCaAlg(Integer.valueOf(caAlg));
        certBean.setCertType(Integer.valueOf(certType));
        certBean.setCertState(CertBean.ENUM_CERT_STATE.normal.value);
        certBean.setCert(CertUtil.certToFullB64((Certificate)x509).replace("\r", "\\r").replace("\n", "\\n"));
        certBean.setPublicKey(CertUtil.getPubKey((String)cert, (int)caAlg));
        certBean.setBefore(Long.valueOf(x509.getNotBefore().getTime()));
        certBean.setAfter(Long.valueOf(x509.getNotAfter().getTime()));
        certList.add(certBean);
        this.datas.put(cardNo, certList);
    }

    public Map<String, List<CertBean>> getDatas() {
        return this.datas;
    }

    public void setDatas(Map<String, List<CertBean>> datas) {
        this.datas = datas;
    }

    public static void main(String[] args) throws Exception {
        ResolveCert resolve = new ResolveCert();
        resolve.resolve("D:/certCard2.xml");
        Map map = resolve.getDatas();
        System.out.println("\u603b\u957f\u5ea6=" + map.size());
        for (String key : map.keySet()) {
            System.out.println("key============" + key);
            List list = (List)map.get(key);
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    CertBean bean = (CertBean)list.get(i);
                    System.out.println("\u7b2c" + i + "\u4e2aCardNo:" + bean.getCardNo());
                    System.out.println("\u7b2c" + i + "\u4e2asn:" + bean.getSn());
                    System.out.println("\u7b2c" + i + "\u4e2aCaAlg:" + bean.getCaAlg());
                    System.out.println("\u7b2c" + i + "\u4e2aCertType:" + bean.getCertType());
                }
                continue;
            }
            System.err.println("errorCardNo=" + key);
        }
    }
}

