<#--
异步分页条标签
-->
<#macro ajaxPaging columns={} formId="pagingForm" listAction="list.do" pgSizeList=[10,15,20,30,40,50]>
	<#if formId != "pagingForm">
		<script type="text/javascript">
			$("#${formId}").append($('<input type="hidden" name="pageNo" />')).append('<input type="hidden" name="pageSize" />');
		</script>
	<#else>
		<form id="${formId}" method="post">
			<input type="hidden" name="pageNo" />
			<input type="hidden" name="pageSize" />
		</form>
	</#if>
	<table align="center" border="0" cellpadding="0" cellspacing="0" class="pagebar">
		<tr>
			<td>共 <span id="totalCount">0</span> 条&nbsp;每页</td>
			<td>
				<@p.select name="pageSize" list=pgSizeList onChange="goPage" height="185" width="50"/>
			</td>
			<td style="padding-left: 5px;">
				条<span class="pageSplit"></span>
			</td>
			<td><input type="button" id="firstBtn" class="pageBtn pageFirstDisable" disabled="disabled" title="首页"/></td>
			<td><input type="button" id="preBtn" class="pageBtn pagePreDisable" disabled="disabled" title="上一页"/>	</td>
			<td><input type="button" id="nextBtn" class="pageBtn pageNextDisable" disabled="disabled" title="下一页"/></td>
			<td><input type="button" id="lastBtn" class="pageBtn pageLastDisable" disabled="disabled" title="尾页"/></td>
			<td><span class="pageSplit"></span>当前 <span id="pageNo">0</span>/<span id="totalPage">0</span> 页 &nbsp;转到第</td>
			<td><input type="text" id="_goPs" style="width:50px;border: 1px solid #ccc;" maxlength="9"/></td>
			<td>页</td>
			<td><input id="_goPage" type="button" onclick="_gotoPage($('#_goPs').val());" class="pageBtn pageGoDisable" disabled="disabled" title="转到"/></td>
		</tr>
	</table>
	<script type="text/javascript">
	function goPage() {
		$('#_goPage').click();
	}
	function _gotoPage(pageNo) {
		try{
			$("input[name=pageNo]").val(pageNo);
			$("input[name=pageSize]").val($("#pageSize").val());
			refresh();
		} catch(e) {
			alert('_gotoPage(pageNo)方法出错');
		}
	}
	function refresh() {
		$.ajax({
			type: "POST",
	    url: "${listAction}",
	    data: $("#${formId}").serialize(),
	    success: function(result){
				if(result) {
					if(typeof result == "string") {
						result = eval("(" + result + ")");
					}
					$("#totalCount").html(result.data.totalCount);
					$("#pageNo").html(result.data.pageNo);
					$("#_goPs").val(result.data.pageNo);
					$("input[name=pageNo]").val(result.data.pageNo);
					$("#totalPage").html(result.data.totalPage);
					$("#pageSize").val(result.data.pageSize);
					$("input[name='pageSize']").val(result.data.pageSize);
					if(result.data.firstPage) {
						$("#firstBtn").addClass("pageFirstDisable").removeClass("pageFirst").attr("disabled", true);
						$("#preBtn").addClass("pagePreDisable").removeClass("pagePre").attr("disabled", true);
					} else {
						$("#firstBtn").addClass("pageFirst").removeClass("pageFirstDisable").attr("disabled", false);
						$("#preBtn").addClass("pagePre").removeClass("pagePreDisable").attr("disabled", false);
					}
					if(result.data.lastPage) {
						$("#lastBtn").addClass("pageLastDisable").removeClass("pageLast").attr("disabled", true);
						$("#nextBtn").addClass("pageNextDisable").removeClass("pageNext").attr("disabled", true);
					} else {
						$("#lastBtn").addClass("pageLast").removeClass("pageLastDisable").attr("disabled", false);
						$("#nextBtn").addClass("pageNext").removeClass("pageNextDisable").attr("disabled", false);
					}
					if(result.data.totalPage==1) {
						$("#_goPage").addClass("pageGoDisable").removeClass("pageGo").attr("disabled", true);
					} else {
						$("#_goPage").addClass("pageGo").removeClass("pageGoDisable").attr("disabled", false);
					}
					
					var gridTable = $(".gridTable");
					var thead = $(".thead", gridTable);
					if(thead.length == 0 && result.head) {
						var thead = $('<tr align="center" class="thead" />').appendTo($(".gridTable"));
						for(var key in result.head) {
							var head = result.head[key];
							if(typeof head == "string") {
								$("<td>" + result.head[key] + "</td>").appendTo(thead);
							} else {
								$("<td width=" + (result.head[key].width || "*") + ">" + result.head[key].label + "</td>").appendTo(thead);
							}
						}
					}
					$(".tbody", gridTable).remove();
					if(result.data.list) {
						var size = result.data.list.length;
						for(var index = 0; index < size; index++) {
							var item = result.data.list[index];
							var tbody = $("<tr class='tbody' />").appendTo(gridTable);
							<#if columns?size != 0>
							<#list columns?keys as key>
								value = item["${key}"]==null ? "——" : item["${key}"];
								$("<td />").attr("tip", value).text(value).appendTo(tbody);
							</#list>
							<#else>
								for(var key in result.head) {
									value = item[key]==null ? "——" : item[key];
									$("<td />").attr("tip", value).text(value).appendTo(tbody);
								}
							</#if>
						}
					}
					showTip();
				}
			}
		});
	}
	
	$(function(){
		$("#_goPs").keypress(function(event){
			if(event.which == 13) {
				$('#_goPage').click();
				return false;
			}
    		if((event.which > 47 && event.which < 58) || event.which == 8) {
    			return true;
    		}
        	return false;
		});
		
		$("#firstBtn").click(function() {_gotoPage(1)});
		$("#preBtn").click(function() {_gotoPage(parseInt($("input[name=pageNo]").val()) - 1)});
		$("#nextBtn").click(function() {_gotoPage(parseInt($("input[name=pageNo]").val()) + 1)});
		$("#lastBtn").click(function() {_gotoPage($("#totalPage").html())});
		
		<#if columns?size != 0>
		var thead = $('<tr align="center" class="thead" />').appendTo($(".gridTable"));
		<#list columns?keys as key>
			$("<td>${columns[key]}</td>").appendTo(thead);
		</#list>
		</#if>
		refresh();
	});
	</script>
</#macro>