<#--
表格标签：用于显示列表数据。
	value：分页信息对应PaginationInfo。
-->
<#macro paging value formId="pagingForm" listAction="list.do" pgSizeList=[5,10,15,20,25,30,40] psHeight="185">
	<#if formId != "pagingForm">
		<script type="text/javascript">
			$("#${formId}").append($('<input type="hidden" name="pageNo" value="${value.pageNo}" />')).append('<input type="hidden" name="pageSize" value="${value.pageSize}" />');
		</script>
	<#else>
		<form id="${formId}" action="${listAction}" method="post">
			<input type="hidden" name="pageNo" value="${value.pageNo}" />
			<input type="hidden" name="pageSize" value="${value.pageSize}" />
		</form>
	</#if>
	<table align="center" border="0" cellpadding="0" cellspacing="0" class="pagebar">
		<tr>
			<td>共 ${value.totalCount} 条&nbsp;每页</td>
			<td>
				<@p.select name="pageSize" value=value.pageSize list=pgSizeList onChange="goPage" height=psHeight width="50"/>
			</td>
			<td style="padding-left: 5px;">
				条<span class="pageSplit"></span>
			</td>
			<td><input type="button" onclick="_gotoPage('1');" class="pageBtn<#if value.firstPage> pageFirstDisable" disabled="disabled"<#else> pageFirst"</#if> title="首页"/></td>
			<td><input type="button" onclick="_gotoPage('${value.prePage}');" class="pageBtn<#if value.firstPage> pagePreDisable" disabled="disabled"<#else> pagePre"</#if> title="上一页"/>	</td>
			<td><input type="button" onclick="_gotoPage('${value.nextPage}');" class="pageBtn<#if value.lastPage> pageNextDisable" disabled="disabled"<#else> pageNext"</#if> title="下一页"/></td>
			<td><input type="button" onclick="_gotoPage('${value.totalPage}');" class="pageBtn<#if value.lastPage> pageLastDisable" disabled="disabled"<#else> pageLast"</#if> title="尾页"/></td>
			<td><span class="pageSplit"></span>当前 ${value.pageNo}/${value.totalPage} 页 &nbsp;转到第</td>
			<td><input type="text" id="_goPs" style="width:50px;border: 1px solid #ccc;" maxlength="9"/></td>
			<td>页</td>
			<td><input id="_goPage" type="button" onclick="_gotoPage($('#_goPs').val());" class="pageBtn<#if value.totalPage==1> pageGoDisable" disabled="disabled"<#else> pageGo"</#if> title="转到"/></td>
		</tr>
	</table>
	<script type="text/javascript">
	$(function(){
		$("#_goPs").keypress(function(event){
			if(event.which == 13) {
				$('#_goPage').click();
				return false;
			}
    		if((event.which > 47 && event.which < 58) || event.which == 8) {
    			return true;
    		}
        	return false;
		});
	})
	function goPage() {
		$('#_goPage').click();
	}
	function _gotoPage(pageNo) {
		try{
			var pagingForm = $("#${formId}");
			$("input[name=pageNo]").val(pageNo);
			$("input[name=pageSize]").val($("#pageSize").val());
			pagingForm.submit();
		} catch(e) {
			alert('_gotoPage(pageNo)方法出错');
		}
	}
	function refresh() {
		$("#${formId}").submit();
	}
	</script>
</#macro>