/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.asset.action;

import com.xdja.cssp.ams.assetmanager.entity.AssetImportMsg;
import com.xdja.cssp.ams.assetmanager.entity.ImportResultBean;
import com.xdja.cssp.ams.assetmanager.service.IAssetManagerService;
import com.xdja.cssp.ams.log.entity.SystemLog;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.cssp.ams.web.util.ExcelUtil;
import com.xdja.cssp.ams.web.util.HttpSessionUtil;
import com.xdja.cssp.ams.web.util.ResolveCert;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class AssetCertAction
extends BaseAction {
    private IAssetManagerService assetManagerService = (IAssetManagerService)DefaultServiceRefer.getServiceRefer(IAssetManagerService.class);

    @RequestMapping(value={"/asset/cert/index.do"})
    public String index(ModelMap model) {
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        String path = HttpSessionUtil.getRootPath() + "/download/" + user.getCardId() + "certResult.xls";
        File file = new File(path);
        if (file.exists()) {
            model.addAttribute("isExsit", (Object)"1");
        } else {
            model.addAttribute("isExsit", (Object)"2");
        }
        model.addAttribute("cardId", (Object)user.getCardId());
        return "asset/cert/index";
    }

    @RequestMapping(value={"/asset/cert/import.do"}, method={RequestMethod.POST})
    public void downloadTemplate(@RequestParam(required=false) @RequestPart MultipartFile file, ModelMap model, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        try {
            response.setCharacterEncoding("UTF-8");
            request.setCharacterEncoding("UTF-8");
            if (file.isEmpty()) {
                result.put("message", "\u8bf7\u5148\u9009\u62e9\u6587\u4ef6");
                this.logger.error("\u8bf7\u9009\u62e9\u6587\u4ef6");
                this.renderText(response, this.toJsonStr(result));
                return;
            }
            if (!file.getOriginalFilename().endsWith(".xml")) {
                result.put("message", "\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                this.logger.error("\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                this.renderText(response, this.toJsonStr(result));
                return;
            }
            if (file.getSize() > 0x500000L) {
                result.put("message", "\u9009\u62e9\u7684\u6587\u4ef6\u5927\u5c0f\u6700\u5927\u5141\u8bb85M");
                this.logger.error("\u9009\u62e9\u7684\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u9650\u52365M");
                this.renderText(response, this.toJsonStr(result));
                return;
            }
            String path = HttpSessionUtil.getRootPath() + "/download/" + user.getCardId() + "certResult.xls";
            String failFileName = String.valueOf(System.nanoTime()) + ".xls";
            ResolveCert resolveCert = new ResolveCert();
            resolveCert.resolve(file.getInputStream());
            Map datas = resolveCert.getDatas();
            ImportResultBean resultBean = this.assetManagerService.importAssetCerts(datas);
            if (null != resultBean) {
                if (resultBean.getFailCount() > 0) {
                    try {
                        this.createAssetFailMsgExcel(path, resultBean.getFailCardsMsg());
                        result.put("failFileName", failFileName);
                    }
                    catch (Exception e) {
                        result.put("failFileName", "");
                    }
                } else {
                    this.deleteAssetFailMsgExcel(path);
                }
                result.put("total", resultBean.getSucessCount() + resultBean.getFailCount());
                result.put("successCount", resultBean.getSucessCount());
                result.put("failCount", resultBean.getFailCount());
                Integer[] detail = (Integer[])resultBean.getDetail();
                result.put("repetitionFail", detail[0]);
                result.put("repetitionDataFail", detail[1]);
                result.put("numberFail", detail[2]);
                result.put("algorithmFail", detail[3]);
                result.put("unExistsAssetFail", detail[4]);
                result.put("unExistsCertFail", detail[5]);
                result.put("success", true);
            }
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.assetManagerLog.value);
            extData.put("logType", (Object)11);
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458{}\u5bfc\u5165\u53d8\u66f4\u8bc1\u4e66\u6210\u529f, \u6587\u4ef6\u540d\u79f0\uff1a{}\uff0c\u6587\u4ef6\u5927\u5c0f\uff1a{} b\uff0c\u6570\u636e\u603b\u6761\u6570\uff1a{}\uff0c\u6210\u529f\uff1a{}\uff0c\u5931\u8d25\uff1a{}", new Object[]{user.getUserName(), file.getOriginalFilename(), file.getSize(), result.get("total"), result.get("successCount"), result.get("failCount")});
        }
        catch (Exception e) {
            result.put("message", "\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            this.logger.error("\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        this.renderText(response, this.toJsonStr(result));
    }

    private void deleteAssetFailMsgExcel(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    private void createAssetFailMsgExcel(String fileName, List<AssetImportMsg> failCardsMsg) {
        this.deleteAssetFailMsgExcel(fileName);
        File newFile = new File(fileName);
        try {
            FileOutputStream out = new FileOutputStream(newFile);
            ExcelUtil.getExcel((OutputStream)out, (String)"\u5bfc\u5165\u5931\u8d25\u7ed3\u679c", (String)"\u8bc1\u4e66\u5bfc\u5165\u5931\u8d25\u7ed3\u679c", failCardsMsg);
        }
        catch (FileNotFoundException e1) {
            this.logger.error("\u6587\u4ef6", (Throwable)e1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

