/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.asset.action;

import com.xdja.cssp.ams.assetmanager.entity.AssetDetails;
import com.xdja.cssp.ams.assetmanager.entity.AssetImportMsg;
import com.xdja.cssp.ams.assetmanager.entity.AssetOrderImportMsg;
import com.xdja.cssp.ams.assetmanager.entity.ImportResultBean;
import com.xdja.cssp.ams.assetmanager.service.IAssetInfoService;
import com.xdja.cssp.ams.assetmanager.service.IAssetManagerService;
import com.xdja.cssp.ams.log.entity.SystemLog;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.cssp.ams.web.system.action.DicInitCache;
import com.xdja.cssp.ams.web.util.Constants;
import com.xdja.cssp.ams.web.util.ExcelResolveUtil;
import com.xdja.cssp.ams.web.util.ExcelUtil;
import com.xdja.cssp.ams.web.util.ResolveCert;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class AssetChangeAction
extends BaseAction {
    private IAssetManagerService assetService = (IAssetManagerService)DefaultServiceRefer.getServiceRefer(IAssetManagerService.class);
    private IAssetInfoService assetInfoService = (IAssetInfoService)DefaultServiceRefer.getServiceRefer(IAssetInfoService.class);

    @RequestMapping(value={"/asset/change/index.do"})
    public String index(ModelMap model) {
        model.addAttribute("assetTypes", (Object)DicInitCache.getDics((String)"importAssetType"));
        return "asset/change/index";
    }

    @RequestMapping(value={"/asset/change/format.do"}, method={RequestMethod.POST})
    public void downloadTemplate(@RequestParam(required=false) @RequestPart MultipartFile formatFile, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> result;
        block11: {
            TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
            result = new HashMap<String, Object>();
            result.put("success", false);
            try {
                String typeStr = request.getParameter("id");
                String type = typeStr.substring(0, 1);
                response.setCharacterEncoding("UTF-8");
                request.setCharacterEncoding("UTF-8");
                if (StringUtils.isBlank((CharSequence)type)) {
                    result.put("message", "\u8bf7\u9009\u62e9\u683c\u5f0f\u5316\u8d44\u4ea7\u7c7b\u578b");
                    this.logger.error("\u8bf7\u9009\u62e9\u683c\u5f0f\u5316\u8d44\u4ea7\u7c7b\u578b");
                    this.renderText(response, this.toJsonStr(result));
                    return;
                }
                if (formatFile.isEmpty()) {
                    result.put("message", "\u8bf7\u5148\u9009\u62e9\u6587\u4ef6");
                    this.logger.error("\u8bf7\u9009\u62e9\u6587\u4ef6");
                    this.renderText(response, this.toJsonStr(result));
                    return;
                }
                if (!formatFile.getOriginalFilename().endsWith(Constants.getImportFileSuffix((int)13))) {
                    result.put("message", "\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                    this.logger.error("\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                    this.renderText(response, this.toJsonStr(result));
                    return;
                }
                ImportResultBean resultBean = null;
                ExcelResolveUtil resolve = new ExcelResolveUtil(formatFile.getInputStream(), 0, 1);
                List mobiles = resolve.getDatasInSheet();
                if (null == mobiles || mobiles.isEmpty()) {
                    result.put("message", "\u6587\u4ef6\u4e0d\u5305\u542b\u6570\u636e\u6216\u5927\u4e8e20000\u6761");
                } else {
                    resultBean = type.trim().equals("1") ? this.assetService.formatBakcard(mobiles) : this.assetService.formatAsset(mobiles);
                }
                if (null == resultBean) break block11;
                if (resultBean.getFailCount() > 0) {
                    String failFileName = String.valueOf(System.nanoTime()) + ".xls";
                    String path = Constants.getImportFailFilePath() + failFileName;
                    try {
                        this.createAssetFailMsgExcel(path, resultBean.getFailCardsMsg());
                        result.put("failFileName", failFileName);
                    }
                    catch (Exception e) {
                        result.put("failFileName", "");
                    }
                }
                result.put("total", resultBean.getSucessCount() + resultBean.getFailCount());
                result.put("successCount", resultBean.getSucessCount());
                result.put("failCount", resultBean.getFailCount());
                Integer[] detail = (Integer[])resultBean.getDetail();
                result.put("repetitionFail", detail[0]);
                result.put("unExistsAssetFail", detail[1]);
                result.put("unDistinguishKuepFail", detail[2]);
                if (type.trim().equals("1")) {
                    result.put("isUseBackcardFail", detail[3]);
                }
                result.put("success", true);
                LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.assetManagerLog.value);
                extData.put("logType", (Object)10);
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458\u3010{}\u3011\u683c\u5f0f\u5316\u8d44\u4ea7\u6210\u529f\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}\uff0c\u6587\u4ef6\u5927\u5c0f\uff1a{} b\uff0c\u6570\u636e\u603b\u6761\u6570\uff1a{}\uff0c\u6210\u529f\uff1a{}\uff0c\u5931\u8d25\uff1a{}", new Object[]{user.getUserName(), formatFile.getOriginalFilename(), formatFile.getSize(), result.get("total"), result.get("successCount"), result.get("failCount")});
            }
            catch (Exception e) {
                result.put("message", "\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                this.logger.error("\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
        this.renderText(response, this.toJsonStr(result));
    }

    @RequestMapping(value={"/asset/change/infoChange.do"}, method={RequestMethod.POST})
    public void downloadInfoChange(@RequestParam(required=false) @RequestPart MultipartFile infoFile, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> result;
        block9: {
            TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
            result = new HashMap<String, Object>();
            result.put("success", false);
            try {
                response.setCharacterEncoding("UTF-8");
                request.setCharacterEncoding("UTF-8");
                if (infoFile.isEmpty()) {
                    result.put("message", "\u8bf7\u5148\u9009\u62e9\u6587\u4ef6");
                    this.logger.error("\u8bf7\u9009\u62e9\u6587\u4ef6");
                    this.renderText(response, this.toJsonStr(result));
                    return;
                }
                if (!infoFile.getOriginalFilename().endsWith(Constants.getImportFileSuffix((int)13))) {
                    result.put("message", "\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                    this.logger.error("\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                    this.renderText(response, this.toJsonStr(result));
                    return;
                }
                ImportResultBean resultBean = null;
                ExcelResolveUtil resolve = new ExcelResolveUtil(infoFile.getInputStream(), 0, 8);
                List mobiles = resolve.getDatasInSheet();
                if (null == mobiles || mobiles.isEmpty()) {
                    result.put("message", "\u6587\u4ef6\u4e0d\u5305\u542b\u6570\u636e\u6216\u5927\u4e8e20000\u6761");
                } else {
                    resultBean = this.assetService.infoChange(mobiles);
                }
                if (null == resultBean) break block9;
                if (resultBean.getFailCount() > 0) {
                    String failFileName = String.valueOf(System.nanoTime()) + ".xls";
                    String path = Constants.getImportFailFilePath() + failFileName;
                    try {
                        this.createAssetFailMsgExcel(path, resultBean.getFailCardsMsg());
                        result.put("failFileName", failFileName);
                    }
                    catch (Exception e) {
                        result.put("failFileName", "");
                    }
                }
                result.put("total", resultBean.getSucessCount() + resultBean.getFailCount());
                result.put("successCount", resultBean.getSucessCount());
                result.put("failCount", resultBean.getFailCount());
                Integer[] detail = (Integer[])resultBean.getDetail();
                result.put("requiredFail", detail[0]);
                result.put("repetitionFail", detail[1]);
                result.put("repetitionDataFail", detail[2]);
                result.put("unExistsAssetFail", detail[3]);
                result.put("success", true);
                LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.assetManagerLog.value);
                extData.put("logType", (Object)10);
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458\u3010{}\u3011\u8fdb\u884c\u5176\u4ed6\u4fe1\u606f\u53d8\u66f4\u6210\u529f\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}\uff0c\u6587\u4ef6\u5927\u5c0f\uff1a{} b\uff0c\u6570\u636e\u603b\u6761\u6570\uff1a{}\uff0c\u6210\u529f\uff1a{}\uff0c\u5931\u8d25\uff1a{}", new Object[]{user.getUserName(), infoFile.getOriginalFilename(), infoFile.getSize(), result.get("total"), result.get("successCount"), result.get("failCount")});
            }
            catch (Exception e) {
                result.put("message", "\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                this.logger.error("\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
        this.renderText(response, this.toJsonStr(result));
    }

    @RequestMapping(value={"/asset/change/deadLineChange.do"}, method={RequestMethod.POST})
    public void downloadDeadLineChange(@RequestParam(required=false) @RequestPart MultipartFile deadLineInfoFile, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> result;
        block9: {
            TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
            result = new HashMap<String, Object>();
            result.put("success", false);
            try {
                response.setCharacterEncoding("UTF-8");
                request.setCharacterEncoding("UTF-8");
                if (deadLineInfoFile.isEmpty()) {
                    result.put("message", "\u8bf7\u5148\u9009\u62e9\u6587\u4ef6");
                    this.logger.error("\u8bf7\u9009\u62e9\u6587\u4ef6");
                    this.renderText(response, this.toJsonStr(result));
                    return;
                }
                if (!deadLineInfoFile.getOriginalFilename().endsWith(Constants.getImportFileSuffix((int)13))) {
                    result.put("message", "\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                    this.logger.error("\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                    this.renderText(response, this.toJsonStr(result));
                    return;
                }
                ImportResultBean resultBean = null;
                ExcelResolveUtil resolve = new ExcelResolveUtil(deadLineInfoFile.getInputStream(), 0, 3);
                List mobiles = resolve.getDatasInSheet();
                if (null == mobiles || mobiles.isEmpty()) {
                    result.put("message", "\u6587\u4ef6\u4e0d\u5305\u542b\u6570\u636e\u6216\u5927\u4e8e20000\u6761");
                } else {
                    resultBean = this.assetService.deadLineActivateChange(mobiles);
                }
                if (null == resultBean) break block9;
                if (resultBean.getFailCount() > 0) {
                    String failFileName = String.valueOf(System.nanoTime()) + ".xls";
                    String path = Constants.getImportFailFilePath() + failFileName;
                    try {
                        this.createAssetOrderFailMsgExcel(path, resultBean.getFailCardsOrdersMsg());
                        result.put("failFileName", failFileName);
                    }
                    catch (Exception e) {
                        result.put("failFileName", "");
                    }
                }
                result.put("total", resultBean.getSucessCount() + resultBean.getFailCount());
                result.put("successCount", resultBean.getSucessCount());
                result.put("failCount", resultBean.getFailCount());
                Integer[] detail = (Integer[])resultBean.getDetail();
                result.put("requiredFail", detail[0]);
                result.put("formatFail", detail[1]);
                result.put("repetitionFail", detail[2]);
                result.put("unExistsAssetFail", detail[3]);
                result.put("unExistsOrderFail", detail[4]);
                result.put("unmatchAssetAndOrderFail", detail[5]);
                result.put("success", true);
                LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.assetManagerLog.value);
                extData.put("logType", (Object)10);
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458\u3010{}\u3011\u8fdb\u884c\u5176\u4ed6\u4fe1\u606f\u53d8\u66f4\u6210\u529f\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}\uff0c\u6587\u4ef6\u5927\u5c0f\uff1a{} b\uff0c\u6570\u636e\u603b\u6761\u6570\uff1a{}\uff0c\u6210\u529f\uff1a{}\uff0c\u5931\u8d25\uff1a{}", new Object[]{user.getUserName(), deadLineInfoFile.getOriginalFilename(), deadLineInfoFile.getSize(), result.get("total"), result.get("successCount"), result.get("failCount")});
            }
            catch (Exception e) {
                result.put("message", "\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                this.logger.error("\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
        this.renderText(response, this.toJsonStr(result));
    }

    @RequestMapping(value={"/asset/change/allowChange.do"}, method={RequestMethod.POST})
    public void downloadAllowChange(@RequestParam(required=false) @RequestPart MultipartFile allowInfoFile, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> result;
        block9: {
            TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
            result = new HashMap<String, Object>();
            result.put("success", false);
            try {
                response.setCharacterEncoding("UTF-8");
                request.setCharacterEncoding("UTF-8");
                if (allowInfoFile.isEmpty()) {
                    result.put("message", "\u8bf7\u5148\u9009\u62e9\u6587\u4ef6");
                    this.logger.error("\u8bf7\u9009\u62e9\u6587\u4ef6");
                    this.renderText(response, this.toJsonStr(result));
                    return;
                }
                if (!allowInfoFile.getOriginalFilename().endsWith(Constants.getImportFileSuffix((int)13))) {
                    result.put("message", "\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                    this.logger.error("\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                    this.renderText(response, this.toJsonStr(result));
                    return;
                }
                ImportResultBean resultBean = null;
                ExcelResolveUtil resolve = new ExcelResolveUtil(allowInfoFile.getInputStream(), 0, 3);
                List mobiles = resolve.getDatasInSheet();
                if (null == mobiles || mobiles.isEmpty()) {
                    result.put("message", "\u6587\u4ef6\u4e0d\u5305\u542b\u6570\u636e\u6216\u5927\u4e8e20000\u6761");
                } else {
                    resultBean = this.assetService.allowActivateChange(mobiles);
                }
                if (null == resultBean) break block9;
                if (resultBean.getFailCount() > 0) {
                    String failFileName = String.valueOf(System.nanoTime()) + ".xls";
                    String path = Constants.getImportFailFilePath() + failFileName;
                    try {
                        this.createAssetOrderFailMsgExcel(path, resultBean.getFailCardsOrdersMsg());
                        result.put("failFileName", failFileName);
                    }
                    catch (Exception e) {
                        result.put("failFileName", "");
                    }
                }
                result.put("total", resultBean.getSucessCount() + resultBean.getFailCount());
                result.put("successCount", resultBean.getSucessCount());
                result.put("failCount", resultBean.getFailCount());
                Integer[] detail = (Integer[])resultBean.getDetail();
                result.put("requiredFail", detail[0]);
                result.put("formatFail", detail[1]);
                result.put("repetitionFail", detail[2]);
                result.put("unExistsAssetFail", detail[3]);
                result.put("unExistsOrderFail", detail[4]);
                result.put("unmatchAssetAndOrderFail", detail[5]);
                result.put("success", true);
                LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.assetManagerLog.value);
                extData.put("logType", (Object)10);
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458\u3010{}\u3011\u8fdb\u884c\u5176\u4ed6\u4fe1\u606f\u53d8\u66f4\u6210\u529f\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}\uff0c\u6587\u4ef6\u5927\u5c0f\uff1a{} b\uff0c\u6570\u636e\u603b\u6761\u6570\uff1a{}\uff0c\u6210\u529f\uff1a{}\uff0c\u5931\u8d25\uff1a{}", new Object[]{user.getUserName(), allowInfoFile.getOriginalFilename(), allowInfoFile.getSize(), result.get("total"), result.get("successCount"), result.get("failCount")});
            }
            catch (Exception e) {
                result.put("message", "\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                this.logger.error("\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
        this.renderText(response, this.toJsonStr(result));
    }

    private void createAssetFailMsgExcel(String fileName, List<AssetImportMsg> failCardsMsg) throws Exception {
        File newFile = new File(fileName);
        try {
            FileOutputStream out = new FileOutputStream(newFile);
            ExcelUtil.getExcel((OutputStream)out, (String)"\u5bfc\u5165\u5931\u8d25\u7ed3\u679c", (String)"\u5bfc\u5165\u5931\u8d25\u7ed3\u679c", failCardsMsg);
        }
        catch (Exception e) {
            this.logger.error("\u5199\u5165\u5931\u8d25\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    private void createAssetOrderFailMsgExcel(String fileName, List<AssetOrderImportMsg> failCardsOrdersMsg) throws Exception {
        File newFile = new File(fileName);
        try {
            FileOutputStream out = new FileOutputStream(newFile);
            ExcelUtil.getExcel((OutputStream)out, (String)"\u5bfc\u5165\u5931\u8d25\u7ed3\u679c", (String)"\u5bfc\u5165\u5931\u8d25\u7ed3\u679c", failCardsOrdersMsg);
        }
        catch (Exception e) {
            this.logger.error("\u5199\u5165\u5931\u8d25\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    @RequestMapping(value={"/asset/change/queryAssetByCard.do"})
    public String queryAsset(AssetDetails assetInfo, HttpServletResponse response, ModelMap model) {
        try {
            if (StringUtils.isNotBlank((CharSequence)assetInfo.getCardNo())) {
                AssetDetails detail = this.assetInfoService.getAssetInfo(assetInfo);
                if (null == detail) {
                    this.renderText(response, "noAsset");
                } else {
                    detail.setAssetType((String)DicInitCache.getDics((String)"assetType").get(detail.getAssetType()));
                    model.addAttribute("assetInfo", (Object)detail);
                }
            } else {
                this.renderText(response, "noAsset");
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u8d44\u4ea7\u4fe1\u606f\u65f6\u5f02\u5e38.", (Throwable)e);
            this.renderText(response, "error");
        }
        return "asset/change/assetInfo";
    }

    @RequestMapping(value={"/asset/change/cardChange.do"}, method={RequestMethod.POST})
    public void downloadCardChange(@RequestPart MultipartFile cardFile, @RequestPart MultipartFile certFile, @RequestParam(required=false) @RequestPart MultipartFile unCodeFile, String assetCardNo, HttpServletRequest request, HttpServletResponse response) {
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        HashMap<String, Object> result = new HashMap<String, Object>();
        List unCodes = new ArrayList();
        result.put("success", false);
        try {
            ExcelResolveUtil resolveUnCode;
            response.setCharacterEncoding("UTF-8");
            request.setCharacterEncoding("UTF-8");
            if (cardFile.isEmpty() || certFile.isEmpty()) {
                result.put("message", "\u8bf7\u5148\u9009\u62e9\u6587\u4ef6");
                this.logger.error("\u8bf7\u9009\u62e9\u6587\u4ef6");
                this.renderText(response, this.toJsonStr(result));
                return;
            }
            if (!cardFile.getOriginalFilename().endsWith(Constants.getImportFileSuffix((int)6)) || !certFile.getOriginalFilename().endsWith(Constants.getImportFileSuffix((int)7)) || unCodeFile != null && StringUtils.isNotBlank((CharSequence)unCodeFile.getOriginalFilename()) && !unCodeFile.getOriginalFilename().endsWith(Constants.getImportFileSuffix((int)8))) {
                result.put("message", "\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                this.logger.error("\u9009\u62e9\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u7b26\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u4e2d\u7684\u683c\u5f0f\u8fdb\u884c\u4e0a\u4f20");
                this.renderText(response, this.toJsonStr(result));
                return;
            }
            boolean flag = true;
            String changeResult = null;
            ExcelResolveUtil resolve = new ExcelResolveUtil(cardFile.getInputStream(), 0, 7);
            List cards = resolve.getDatasInSheetChange();
            if (null == cards || cards.isEmpty()) {
                flag = false;
                result.put("message", "\u82af\u7247\u4fe1\u606f\u53d8\u66f4\u6587\u4ef6\u53ea\u80fd\u5305\u542b\u4e00\u6761\u6570\u636e");
            }
            ResolveCert resolveCert = new ResolveCert();
            resolveCert.resolve(certFile.getInputStream());
            Map certs = resolveCert.getDatas();
            if (null == certs || certs.size() != 1) {
                flag = false;
                result.put("message", "\u82af\u7247\u8bc1\u4e66\u53d8\u66f4\u6587\u4ef6\u53ea\u80fd\u5305\u542b\u4e00\u4e2a\u8d44\u4ea7\u7684\u6570\u636e");
            }
            if (unCodeFile != null && StringUtils.isNotBlank((CharSequence)unCodeFile.getOriginalFilename()) && (null == (unCodes = (resolveUnCode = new ExcelResolveUtil(unCodeFile.getInputStream(), 0, 4)).getDatasInSheetChange()) || unCodes.isEmpty())) {
                flag = false;
                result.put("message", "\u82af\u7247\u89e3\u9501\u7801\u53d8\u66f4\u6587\u4ef6\u53ea\u80fd\u5305\u542b\u4e00\u6761\u6570\u636e");
            }
            if (flag) {
                changeResult = this.assetService.cardChange(assetCardNo, cards, certs, unCodes);
            }
            LoggerExtData extData = LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.assetManagerLog.value);
            if ("success".equals(changeResult)) {
                result.put("success", true);
                extData.put("logType", (Object)10);
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458\u3010{}\u3011\u5bf9\u8d44\u4ea7{}\u8fdb\u884c\u82af\u7247\u53d8\u66f4\u6210\u529f", (Object)user.getUserName(), (Object)assetCardNo);
            } else {
                if (flag) {
                    result.put("message", changeResult);
                }
                this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), extData, "\u7ba1\u7406\u5458\u3010{}\u3011\u5bf9\u8d44\u4ea7{}\u8fdb\u884c\u82af\u7247\u53d8\u66f4\u5931\u8d25,\u5931\u8d25\u539f\u56e0:{}", new Object[]{user.getUserName(), assetCardNo, changeResult});
            }
        }
        catch (Exception e) {
            result.put("message", "\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            this.logger.error("\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        this.renderText(response, this.toJsonStr(result));
    }
}

