/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.customer.action;

import com.xdja.cssp.ams.customer.entity.Order;
import com.xdja.cssp.ams.customer.service.IOrderService;
import com.xdja.cssp.ams.web.json.DataTablesParameters;
import com.xdja.cssp.ams.web.system.action.DicInitCache;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import com.xdja.platform.web.action.BaseAction;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CustomerOrderAction
extends BaseAction {
    private IOrderService orderService = (IOrderService)DefaultServiceRefer.getServiceRefer(IOrderService.class);

    @RequestMapping(value={"/customer/order/index.do"})
    public String toIndex(ModelMap model) {
        model.addAttribute("assetTypeStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"assetType")));
        model.addAttribute("activeTypeStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"activeType")));
        model.addAttribute("assetActiveStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"assetActive")));
        model.addAttribute("orderOriginStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"orderOrigin")));
        return "customer/order/index";
    }

    @RequestMapping(value={"/customer/order/ajaxList.do"})
    @ResponseBody
    public Object ajaxList(Order order) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "", "", "", "", "activeType", "activeLicense", "", "", "", "orderTime", ""};
        LitePaging pagination = this.orderService.queryOrders(order, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/customer/order/detail.do"})
    public String indexDetail(ModelMap modelMap) {
        modelMap.addAttribute("assetTypeStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"assetType")));
        return "customer/order/importInfo";
    }

    @RequestMapping(value={"/customer/order/bakcardDetail.do"})
    public String indexBakcardDetail(ModelMap modelMap) {
        modelMap.addAttribute("assetTypeStr", (Object)this.toJsonStr((Object)DicInitCache.getDics((String)"assetType")));
        return "customer/order/importBakcardInfo";
    }

    @RequestMapping(value={"/customer/order/ajaxDataList.do"})
    @ResponseBody
    public Object ajaxDataList(Order condition) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "", "assetType", "", "", "productionTime", "time"};
        LitePaging pagination = this.orderService.queryAssetDetails(condition, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/customer/order/ajaxBakcardDataList.do"})
    @ResponseBody
    public Object ajaxBakcardDataList(Order condition) {
        DataTablesParameters tables = DataTablesParameters.newInstance();
        String[] orderColumns = new String[]{"", "", "assetType", "", "", "productionTime", "time"};
        LitePaging pagination = this.orderService.queryBakcardDetails(condition, Integer.valueOf(tables.getPage()), Integer.valueOf(tables.getLength()), tables.getOrderColName(orderColumns), tables.getOrderDir());
        return tables.getDataTablesReply(pagination);
    }

    @RequestMapping(value={"/customer/order/editActivateInfo.do"})
    public String editActivateInfo(String orderName, ModelMap modelMap) {
        Order order = this.orderService.getOrderInfoByName(orderName);
        modelMap.addAttribute("activeOrderType", (Object)order.getActiveType());
        modelMap.addAttribute("order", (Object)order);
        return "customer/order/edit";
    }

    @RequestMapping(value={"/customer/order/saveActivateInfo.do"})
    public void saveOrderActiveInfo(Order order, HttpServletResponse response) {
        String message = "success";
        try {
            this.orderService.saveOrderActiveInfo(order);
        }
        catch (IllegalArgumentException e) {
            message = e.getMessage();
            this.logger.error("\u8ba2\u5355\u6fc0\u6d3b\u4fe1\u606f\u4fdd\u5b58\u65f6\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            message = "\u4fdd\u5b58\u8ba2\u5355\u6fc0\u6d3b\u4fe1\u606f\u5931\u8d25";
            this.logger.error("\u4fdd\u5b58\u8ba2\u5355\u6fc0\u6d3b\u4fe1\u606f\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (Throwable)e);
        }
        this.renderText(response, message);
    }
}

