/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.security.action;

import com.xdja.cssp.ams.log.entity.SystemLog;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.cssp.ams.system.service.IFunctionService;
import com.xdja.cssp.ams.system.service.IUserService;
import com.xdja.cssp.ams.web.security.provider.UsernamePasswordCardidToken;
import com.xdja.cssp.ams.web.util.Constants;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.bean.Operator;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class LoginAction
extends BaseAction {
    private IFunctionService functionService = (IFunctionService)DefaultServiceRefer.getServiceRefer(IFunctionService.class);
    private IUserService userService = (IUserService)DefaultServiceRefer.getServiceRefer(IUserService.class);

    @RequestMapping(value={"/login.do"}, method={RequestMethod.GET})
    public String login(ModelMap model, HttpServletRequest request) {
        StringBuilder url = new StringBuilder("https://");
        url.append(request.getServerName()).append(":").append(StringUtils.isBlank((CharSequence)Constants.HTTPS_PORT) ? "8443" : Constants.HTTPS_PORT).append(request.getRequestURI());
        model.addAttribute("loginUrl", (Object)url.toString());
        model.addAttribute("cardDownloadURL", (Object)Constants.CARD_DOWNLOAD_URL);
        model.addAttribute("cardVersion", (Object)Constants.CARD_VERSION);
        return "login";
    }

    @RequestMapping(value={"/login.do"}, method={RequestMethod.POST})
    public String login(String userName, String password, String cardId, ModelMap model, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            model.addAttribute("message", (Object)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (StringUtils.isBlank((CharSequence)password)) {
            model.addAttribute("message", (Object)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            boolean isLogined = true;
            try {
                UsernamePasswordCardidToken token = new UsernamePasswordCardidToken(userName, password);
                token.setCardId(cardId);
                SecurityUtils.getSubject().login((AuthenticationToken)token);
            }
            catch (LockedAccountException e) {
                isLogined = false;
                model.addAttribute("message", (Object)"\u7528\u6237\u88ab\u9501\u5b9a");
            }
            catch (UnknownAccountException e) {
                isLogined = false;
                model.addAttribute("message", (Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            }
            catch (IncorrectCredentialsException e) {
                isLogined = false;
                model.addAttribute("message", (Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            }
            catch (AuthenticationException e) {
                isLogined = false;
                model.addAttribute("message", (Object)e.getMessage());
            }
            if (isLogined) {
                TUser user = this.userService.getUserByUserName(userName);
                user.setCardId(cardId);
                user.setLoginIp(request.getRemoteHost());
                OperatorUtil.setOperator((Operator)new Operator(userName, this.functionService.queryAllFunctions(user)));
                OperatorUtil.getOperator().setCurrUser((Object)user);
                this.logger.info(SystemLog.ENUM_LOG_TYPE.loginLog.value.intValue(), LoggerExtData.create((String)"logType", (Object)1), "\u7ba1\u7406\u5458{}\u767b\u5f55\u6210\u529f", (Object)user.getUserName());
                return "redirect:/index.do";
            }
        }
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("error", (Object)"true");
        return "login";
    }

    @RequestMapping(value={"/logout"})
    public String logout(HttpServletResponse response) {
        TUser user = (TUser)OperatorUtil.getOperator().getCurrUser();
        this.logger.info(SystemLog.ENUM_LOG_TYPE.loginLog.value.intValue(), LoggerExtData.create((String)"logType", (Object)2), "\u7ba1\u7406\u5458{}\u9000\u51fa\u6210\u529f", (Object)user.getUserName());
        SecurityUtils.getSubject().logout();
        return "redirect:/login.do";
    }
}

