/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.task;

import com.xdja.cssp.ams.assetmanager.entity.TLoadRecord;
import com.xdja.cssp.ams.assetmanager.service.ILoadRecordManagerService;
import com.xdja.cssp.ams.log.service.ISystemLogService;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.log.Logger;
import com.xdja.platform.log.LoggerFactory;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.ContextLoader;

public class SyncAssetCleanJob {
    private Logger logger = LoggerFactory.getLogger(SyncAssetCleanJob.class);
    public static final Integer syncCleanDay = 15;
    ILoadRecordManagerService loadRecordManagerService = (ILoadRecordManagerService)DefaultServiceRefer.getServiceRefer(ILoadRecordManagerService.class);
    ISystemLogService systemLogService = (ISystemLogService)DefaultServiceRefer.getServiceRefer(ISystemLogService.class);

    public void executeTask() {
        this.logger.info(".................\u6e05\u7406\u8d44\u4ea7\u5bfc\u5165\u5931\u8d25\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb..............");
        this.syncAssetCleanJob();
        this.logger.info(".................\u6e05\u7406\u8d44\u4ea7\u5bfc\u5165\u5931\u8d25\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f..............");
    }

    public void syncAssetCleanJob() {
        Prop prop = PropKit.use((String)"system.properties");
        Long syncCleanDayTime = prop.getInt("syncCleanDay", syncCleanDay) * 24 * 3600 * 1000;
        Long nowTime = System.currentTimeMillis();
        Long beginTime = nowTime - syncCleanDayTime;
        List recordList = this.loadRecordManagerService.queryCleanFailDataByTime(beginTime);
        if (recordList != null && recordList.size() > 0) {
            for (int i = 0; i < recordList.size(); ++i) {
                String fileName;
                File file;
                TLoadRecord record = (TLoadRecord)recordList.get(i);
                String failurePath = record.getFailurePath();
                if (!StringUtils.isNotBlank((CharSequence)failurePath) || !(file = new File(fileName = ContextLoader.getCurrentWebApplicationContext().getServletContext().getRealPath("/download/" + failurePath))).exists()) continue;
                file.delete();
            }
        }
        this.systemLogService.saveSystemJobLog(this.logger.getName(), "syncAssetRevokeInfo", "\u7cfb\u7edf\u5b9a\u65f6\u6267\u884c\u6e05\u7406\u8d44\u4ea7\u5bfc\u5165\u5931\u8d25\u6587\u4ef6\u64cd\u4f5c\u6210\u529f");
    }
}

