/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.web.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelResolveUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private HSSFWorkbook workbook;
    private int sheetNumber;
    private int rowLenth;

    public ExcelResolveUtil(String fileName, int sheetNum, int rowLenth) throws Exception {
        this.sheetNumber = sheetNum;
        this.rowLenth = rowLenth;
        FileInputStream in = new FileInputStream(new File(fileName));
        try {
            this.workbook = new HSSFWorkbook((InputStream)in);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6Excel\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            throw e;
        }
        finally {
            ((InputStream)in).close();
            in = null;
        }
    }

    public ExcelResolveUtil(InputStream in, int sheetNum, int rowLenth) throws Exception {
        this.sheetNumber = sheetNum;
        this.rowLenth = rowLenth;
        try {
            this.workbook = new HSSFWorkbook(in);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6Excel\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            throw e;
        }
        finally {
            in.close();
            in = null;
        }
    }

    public List<String[]> getDatasInSheet() {
        ArrayList<String[]> result = new ArrayList<String[]>();
        HSSFSheet sheet = this.workbook.getSheetAt(this.sheetNumber);
        int rowCount = sheet.getLastRowNum();
        this.logger.info("found excel rows count:" + rowCount);
        if (rowCount < 1) {
            this.logger.info("EXCEL\u6587\u4ef6\u4e2d\u4e0d\u5305\u542b\u6570\u636e!");
            return null;
        }
        if (rowCount > 20001) {
            this.logger.info("EXCEL\u6587\u4ef6\u4e2d\u6570\u636e\u5927\u4e8e20000\u6761!");
            return null;
        }
        for (int rowIndex = 1; rowIndex <= rowCount; ++rowIndex) {
            HSSFRow row = sheet.getRow(rowIndex);
            if (null == row) continue;
            String[] rowData = new String[this.rowLenth + 1];
            int cellCount = row.getLastCellNum();
            if (cellCount > this.rowLenth) {
                cellCount = this.rowLenth;
            } else if (cellCount < 1) {
                result.add(rowData);
                continue;
            }
            for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
                HSSFCell cell = row.getCell(cellIndex);
                Object cellStr = this.getCellString(cell);
                rowData[cellIndex] = (String)cellStr;
            }
            rowData[this.rowLenth] = String.valueOf(rowIndex + 1);
            result.add(rowData);
        }
        return result;
    }

    private Object getCellString(HSSFCell cell) {
        Object result = null;
        if (cell != null) {
            int cellType = cell.getCellType();
            switch (cellType) {
                case 1: {
                    result = cell.getStringCellValue();
                    break;
                }
                case 0: {
                    result = new DecimalFormat("#").format(cell.getNumericCellValue());
                    break;
                }
                case 2: {
                    result = cell.getNumericCellValue();
                    break;
                }
                case 4: {
                    result = cell.getBooleanCellValue();
                    break;
                }
                case 3: {
                    result = null;
                    break;
                }
                case 5: {
                    result = null;
                    break;
                }
                default: {
                    System.out.println("\u679a\u4e3e\u4e86\u6240\u6709\u7c7b\u578b");
                }
            }
        }
        return result;
    }

    public List<String[]> getDatasInSheetChange() {
        ArrayList<String[]> result = new ArrayList<String[]>();
        HSSFSheet sheet = this.workbook.getSheetAt(this.sheetNumber);
        int rowCount = sheet.getLastRowNum();
        this.logger.info("found excel rows count:" + rowCount);
        if (rowCount != 1) {
            this.logger.info("EXCEL\u6587\u4ef6\u4e2d\u6570\u636e\u4e0d\u552f\u4e00!");
            return null;
        }
        for (int rowIndex = 1; rowIndex <= rowCount; ++rowIndex) {
            HSSFRow row = sheet.getRow(rowIndex);
            if (null == row) continue;
            String[] rowData = new String[this.rowLenth + 1];
            int cellCount = row.getLastCellNum();
            if (cellCount > this.rowLenth) {
                cellCount = this.rowLenth;
            } else if (cellCount < 1) {
                result.add(rowData);
                continue;
            }
            for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
                HSSFCell cell = row.getCell(cellIndex);
                Object cellStr = this.getCellString(cell);
                rowData[cellIndex] = (String)cellStr;
            }
            rowData[this.rowLenth] = String.valueOf(rowIndex + 1);
            result.add(rowData);
        }
        return result;
    }
}

