/**
 * 名称：检查密码强度插件
 * 使用方法：
 * 		$("#newPasswd").pwdStrength();//指示条插入newPasswd之后
 * 		$("#newPasswd").pwdStrength({container:"pwdStrong"});//指示条插入pwdStrong中
 * 作者：周小欠
 * 时间：2012-10-10 10:39 
 */
(function($){
	$.fn.pwdStrength = function(options) {
		var defaults = {container:""};
		var opts = $.extend(defaults,options);
		var container;
		if($.trim(opts.container) == "") {
			container = $(this).parent();
		} else {
			container = $("#" + opts.container);
		}
		//计算输入框的实际宽度
		var padd_left_str = $(this).css("padding-left");
		var padd_right_str = $(this).css("padding-right");
		var brw = $(this).css("border-right-width");
		var blw = $(this).css("border-left-width");
		
		var width = $(this).width() + parseInt(padd_left_str.substring(0, padd_left_str.indexOf("px"))) + parseInt(padd_right_str.substring(0, padd_right_str.indexOf("px")))
		+ parseInt(brw.substring(0, brw.indexOf("px")))+ parseInt(blw.substring(0, blw.indexOf("px")));
		container.append('<table id="pwd_strength_table" style="width:' + width + 'px;"><tr><td id="pwd_strength_L">弱</td><td id="pwd_strength_M">中</td><td id="pwd_strength_H">强</td></tr></table>');
		$(this).keyup(function(){
			var O_color = "#eeeeee";
			var L_color = "#FF0000";
			var M_color = "#FF9900";
			var H_color = "#33CC00";
			var pwd = $(this).val();
			if (pwd == null) {
				Lcolor = Mcolor = Hcolor = O_color;
			} else {
				var level = $.fn.pwdStrength.checkStrong(pwd);
				switch (level) {
				case 0:
					Lcolor = Mcolor = Hcolor = O_color;
				case 1:
					Lcolor = L_color;
					Mcolor = Hcolor = O_color;
					break;
				case 2:
					Lcolor = Mcolor = M_color;
					Hcolor = O_color;
					break;
				default:
					Lcolor = Mcolor = Hcolor = H_color;
					break;
				}
			}
			$("#pwd_strength_L").css("background-color", Lcolor);
			$("#pwd_strength_M").css("background-color", Mcolor);
			$("#pwd_strength_H").css("background-color", Hcolor);
		});
	}
	
	//测试某个字符是属于哪一类.
	$.fn.pwdStrength.charMode = function(charItem) {
		if (charItem >= 48 && charItem <= 57)//数字
			return 1;
		if (charItem >= 65 && charItem <= 90)//大写字母
			return 2;
		if (charItem >= 97 && charItem <= 122)//小写
			return 4;
		else
			return 8;//特殊字符
	}
	
	//计算出当前密码当中一共有多少种模式
	$.fn.pwdStrength.bitTotal = function(num) {
		var modes = 0;
		for (var i = 0; i < 4; i++) {
			if (num & 1)
				modes++;
			num >>>= 1;
		}
		return modes;
	}
	
	//返回密码的强度级别
	$.fn.pwdStrength.checkStrong = function(password) {
		if (password.length <= 4) {
			return 0;//密码太短
		}
		var modes = 0;
		for (var i = 0; i < password.length; i++) {
			//测试每一个字符的类别并统计一共有多少种模式.
			modes |= $.fn.pwdStrength.charMode(password.charCodeAt(i));
		}
		return $.fn.pwdStrength.bitTotal(modes);
	}
})(jQuery);