/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.developer.business.impl;

import com.xdja.cssp.open.developer.business.DeveloperInfoBusiness;
import com.xdja.cssp.open.developer.dao.DeveloperAccountInfoDao;
import com.xdja.cssp.open.developer.dao.DeveloperExtendInfoDao;
import com.xdja.cssp.open.developer.dao.DeveloperInfoDao;
import com.xdja.cssp.open.service.developer.entity.DeveloperExtendInfo;
import com.xdja.cssp.open.service.developer.entity.DeveloperInfo;
import com.xdja.cssp.open.system.entity.TAccountInfo;
import com.xdja.cssp.open.utils.Constants;
import com.xdja.cssp.open.utils.MailUtil;
import com.xdja.platform.redis.core.RedisClient;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;

@Service
public class DeveloperInfoBusinessImpl
implements DeveloperInfoBusiness {
    @Autowired
    DeveloperInfoDao developerInfoDao;
    @Autowired
    DeveloperAccountInfoDao developerAccountInfoDao;
    @Autowired
    DeveloperExtendInfoDao developerExtendInfo;
    @Resource
    RedisClient redisClient;

    @Override
    public int auditDeveloper(Long id, Integer status, String auditRemark, Long userid) {
        if (status == TAccountInfo.ENUM_ACCOUNT_STATUS.auditThrough.value || status == TAccountInfo.ENUM_ACCOUNT_STATUS.auditNotApproved.value) {
            this.redisClient.hset(Constants.OPEN_APP_INFO, "dev_user_" + id + "_status", String.valueOf(status));
        }
        int result = 0;
        try {
            result = this.developerInfoDao.auditDeveloper(id, status, auditRemark, userid);
            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            String dateStr = df.format(new Date());
            String toMail = this.developerInfoDao.queryMailById(id);
            if (StringUtils.isNotBlank((CharSequence)toMail)) {
                if (status == TAccountInfo.ENUM_ACCOUNT_STATUS.auditThrough.value) {
                    StringBuffer strBuffer = new StringBuffer().append(Constants.PASS_EMAIL_CONTENT1).append(toMail).append(Constants.PASS_EMAIL_CONTENT3).append(Constants.COMMON_MAIL_CONTENT1).append(dateStr).append(Constants.COMMON_MAIL_CONTENT2);
                    MailUtil.sendHTMLMail((String)Constants.FROM_MAIL_ADDRESS, (String)toMail, (String)Constants.PASS_EMAIL_SUBJECT, (String)strBuffer.toString());
                } else if (status == TAccountInfo.ENUM_ACCOUNT_STATUS.auditNotApproved.value) {
                    StringBuffer strBuffer = new StringBuffer().append(Constants.REJECT_EMAIL_CONTENT1).append(toMail).append(Constants.REJECT_EMAIL_CONTENT3).append(auditRemark).append(Constants.REJECT_EMAIL_CONTENT5).append(Constants.COMMON_MAIL_CONTENT1).append(dateStr).append(Constants.COMMON_MAIL_CONTENT2);
                    MailUtil.sendHTMLMail((String)Constants.FROM_MAIL_ADDRESS, (String)toMail, (String)Constants.REJECT_EMAIL_SUBJECT, (String)strBuffer.toString());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5ba1\u6838\u7ed3\u679c\u90ae\u4ef6\u901a\u77e5\u5931\u8d25");
        }
        return result;
    }

    @Override
    public Map<String, Object> findDeveloperById(Long id) {
        return this.developerInfoDao.findDeveloperById(id);
    }

    @Override
    public List<Map<String, Object>> list(Integer devType, Integer status, Integer acctType, Long timeStart, Long timeEnd, Long auditTimeStart, Long auditTimeEnd, String keyword, Integer pageNo, Integer pageSize) {
        return this.developerInfoDao.list(devType, status, acctType, timeStart, timeEnd, auditTimeStart, auditTimeEnd, keyword, pageNo, pageSize);
    }

    @Override
    public long count(Integer devType, Integer status, Integer acctType, Long timeStart, Long timeEnd, Long auditTimeStart, Long auditTimeEnd, String keyword, int start, Integer pageSize) {
        return this.developerInfoDao.count(devType, status, acctType, timeStart, timeEnd, auditTimeStart, auditTimeEnd, keyword, start, pageSize);
    }

    @Override
    public Map<String, Object> checkUser(Long id) {
        return this.developerInfoDao.checkUser(id);
    }

    @Override
    public int checkMobile(Long userId, String mobile) {
        return this.developerInfoDao.checkMobile(userId, mobile);
    }

    @Override
    public int checkCompanyName(Long userId, String companyName) {
        return this.developerInfoDao.checkCompanyName(userId, companyName);
    }

    @Override
    public int checkLicenceNo(Long userId, String licenceNo) {
        return this.developerInfoDao.checkLicenceNo(userId, licenceNo);
    }

    @Override
    public int checkOrgName(String orgName) {
        return this.developerInfoDao.checkOrgName(orgName);
    }

    @Override
    public int save(Long id, Integer devType, String surname, String name, String mobile, String validateCode, String country, String city, String trade, String profession, String string, String string2, String string3, String companyName, String licenceNo, String string4, String string5, String orgName, int accType, String identityCard) {
        int result = this.developerInfoDao.save(id);
        if (result == 0) {
            return 0;
        }
        DeveloperExtendInfo exInfo = new DeveloperExtendInfo();
        exInfo.setDevAccId(id);
        DeveloperInfo info = new DeveloperInfo();
        info.setDevAccId(id);
        switch (devType) {
            case 1: {
                info.setName(name);
                info.setIdentityCard(identityCard);
                info.setMobile(mobile);
                info.setCountry(country);
                info.setCity(city);
                info.setTrade(trade);
                info.setDevType(devType);
                info.setAccType(Integer.valueOf(accType));
                info.setTime(Long.valueOf(System.currentTimeMillis()));
                exInfo.setCardfPath(string);
                exInfo.setCardbPath(string2);
                exInfo.setCardpPath(string3);
                break;
            }
            case 2: {
                info.setCompanyName(companyName);
                info.setLicenceNo(licenceNo);
                info.setMobile(mobile);
                info.setCountry(country);
                info.setCity(city);
                info.setTrade(trade);
                info.setDevType(devType);
                info.setAccType(Integer.valueOf(accType));
                info.setTime(Long.valueOf(System.currentTimeMillis()));
                exInfo.setLicensebPath(string5);
                exInfo.setLicensefPath(string4);
                break;
            }
            case 3: {
                info.setOrgName(orgName);
                info.setName(name);
                info.setIdentityCard(identityCard);
                info.setMobile(mobile);
                info.setCountry(country);
                info.setCity(city);
                info.setTrade(trade);
                info.setDevType(devType);
                info.setAccType(Integer.valueOf(accType));
                info.setTime(Long.valueOf(System.currentTimeMillis()));
                exInfo.setCardfPath(string);
                exInfo.setCardbPath(string2);
                exInfo.setCardpPath(string3);
            }
        }
        boolean developerFlag = this.developerAccountInfoDao.queryIsExist(id);
        if (developerFlag) {
            this.developerAccountInfoDao.delInfo(id);
            this.developerExtendInfo.delInfo(id);
        }
        this.developerAccountInfoDao.save(info);
        this.developerExtendInfo.save(exInfo);
        return 1;
    }

    @Override
    public int upgrade(Long id, Integer accType, int oldAccType) {
        return this.developerInfoDao.upgrade(id, accType, oldAccType);
    }

    @Override
    public Map<String, Object> findDeveloperEmail(Long id) {
        return this.developerInfoDao.findDeveloperEmail(id);
    }

    @Override
    public boolean sendSMSCode(Long userid, String code, String mobile) {
        return false;
    }

    @Override
    public int checkIdentityCardIsExist(Long id, String identityCard) {
        return this.developerInfoDao.checkIdentityCardIsExist(id, identityCard);
    }

    @Override
    public Map<String, Object> getUserRegisterInfo(Long id, Integer devType) {
        try {
            return this.developerInfoDao.getUserRegisterInfo(id, devType);
        }
        catch (EmptyResultDataAccessException ea) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

