/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.developer.cache;

import com.xdja.cssp.open.utils.Constants;
import com.xdja.platform.redis.core.RedisClient;
import com.xdja.platform.redis.core.action.JedisActionNoResult;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

@Component
public class MobileCodeCache {
    @Resource
    private RedisClient redisClient;
    private static final String APPINFO_PREFIX = "open_mobile_";

    public Map<String, Object> addMobileCode(final Long userId, String mobile, final String code) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", "error");
        resultMap.put("message", 60);
        final Map cacheUser = this.redisClient.hgetAll("open_mobile_user_" + userId);
        final HashMap<String, String> newCacheCode = new HashMap<String, String>();
        String message = "success";
        final HashMap<String, String> newCacheUser = new HashMap<String, String>();
        newCacheUser.put("nextTime", "60");
        newCacheUser.put("times", String.valueOf(1));
        newCacheUser.put("code", code);
        newCacheUser.put("mobile", mobile);
        newCacheUser.put("userId", String.valueOf(userId));
        if (null != cacheUser && !cacheUser.isEmpty()) {
            int errorTimes;
            int times = Integer.parseInt((String)cacheUser.get("times"));
            if (times >= Constants.PHONE_CODE_LIMIT) {
                message = "\u4f60\u53d1\u9001\u9a8c\u8bc1\u7801\u6b21\u6570\u8fc7\u591a\uff0c\u8bf724\u5c0f\u65f6\u4e4b\u540e\u518d\u8bd5";
                resultMap.put("message", message);
                return resultMap;
            }
            final String oldCode = (String)cacheUser.get("code");
            final Map cacheCode = this.redisClient.hgetAll("open_mobile_code_" + oldCode);
            if (null != cacheCode && !cacheCode.isEmpty() && (errorTimes = Integer.parseInt((String)cacheCode.get("errorTimes"))) >= Constants.PHONE_CODE_ERROR) {
                message = "\u9a8c\u8bc1\u7801\u9519\u8bef\u6b21\u6570\u8fbe\u5230" + Constants.PHONE_CODE_ERROR + "\u6b21\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
                resultMap.put("message", message);
                String delayTime = (String)cacheCode.get("delayTime");
                if (StringUtils.isBlank((CharSequence)delayTime)) {
                    cacheCode.put("delayTime", "true");
                    newCacheCode.put("delayTime", "true");
                    this.redisClient.execute(new JedisActionNoResult(){

                        public void action(Jedis jedis) {
                            Pipeline p = jedis.pipelined();
                            p.hmset("open_mobile_code_" + oldCode, cacheCode);
                            p.expire("open_mobile_code_" + oldCode, 600);
                            p.sync();
                        }
                    });
                }
                return resultMap;
            }
            if (times >= 2) {
                newCacheUser.put("nextTime", "300");
            }
            newCacheUser.put("times", String.valueOf(times + 1));
            resultMap.put("message", newCacheUser.get("nextTime"));
        }
        newCacheCode.put("mobile", mobile);
        newCacheCode.put("errorTimes", String.valueOf(0));
        if (message.equals("success")) {
            this.redisClient.execute(new JedisActionNoResult(){

                public void action(Jedis jedis) {
                    Pipeline p = jedis.pipelined();
                    p.hmset("open_mobile_user_" + userId, newCacheUser);
                    if (null == cacheUser && cacheUser.isEmpty()) {
                        p.expire("open_mobile_user_" + userId, 86400);
                    }
                    p.hmset("open_mobile_code_" + code, newCacheCode);
                    p.expire("open_mobile_code_" + code, 300);
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)cacheUser.get("code")))) {
                        p.del("open_mobile_code_" + (String)cacheUser.get("code"));
                    }
                    p.sync();
                }
            });
        }
        resultMap.put("result", "success");
        return resultMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMobileCodeInfo(Long userId, String mobile, String code) {
        Map cacheUser = this.redisClient.hgetAll("open_mobile_user_" + userId);
        if (null == cacheUser || cacheUser.isEmpty()) return 4;
        String oldCode = (String)cacheUser.get("code");
        Map cacheCode = this.redisClient.hgetAll("open_mobile_code_" + oldCode);
        if (null == cacheCode || cacheCode.isEmpty()) return 4;
        Integer errorTimes = Integer.parseInt((String)cacheCode.get("errorTimes"));
        if (errorTimes >= 3) {
            this.addErrorTimes(cacheCode, oldCode);
            return 3;
        }
        if (code.equalsIgnoreCase(oldCode) && userId == (long)Integer.parseInt((String)cacheUser.get("userId")) && mobile.equals(cacheUser.get("mobile"))) return 0;
        this.addErrorTimes(cacheCode, oldCode);
        return 2;
    }

    public void addErrorTimes(Map<String, String> cacheCode, String code) {
        if (null != cacheCode && !cacheCode.isEmpty() && StringUtils.isNotBlank((CharSequence)code)) {
            cacheCode.put("errorTimes", String.valueOf(Integer.parseInt(cacheCode.get("errorTimes")) + 1));
            this.redisClient.hmset("open_mobile_code_" + code, cacheCode);
        }
    }

    public void delMobileCode(Long userId, String code) {
        this.redisClient.del(new String[]{"open_mobile_user_" + String.valueOf(userId)});
        this.redisClient.del(new String[]{"open_mobile_code_" + code});
    }
}

