/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.developer.dao;

import com.xdja.cssp.open.service.developer.entity.DeveloperInfo;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DeveloperInfoDao
extends BaseJpaDao<DeveloperInfo, Long> {
    public int auditDeveloper(Long id, Integer status, String auditRemark, Long userid) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("UPDATE t_dev_account_info SET ").append("n_status = :status, ").append("n_audit_id = :userid, ").append("n_audit_time = " + System.currentTimeMillis());
        if (StringUtils.isNotEmpty((CharSequence)auditRemark)) {
            sqlBuilder.append(", c_audit_remark = :auditRemark ");
            sqlParameterSource.addValue("auditRemark", (Object)auditRemark);
        }
        sqlBuilder.append(" WHERE n_status = 3 and n_id = :id");
        sqlParameterSource.addValue("status", (Object)status);
        sqlParameterSource.addValue("id", (Object)id);
        sqlParameterSource.addValue("userid", (Object)userid);
        int result = 0;
        result = this.executeSql(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
        return result;
    }

    public Map<String, Object> findDeveloperById(Long id) {
        Map map = null;
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT ta.*, u.c_user_name auditName FROM ( SELECT ").append("ac.n_id id, ac.n_headimg headImgPath, ").append("ac.n_headimg_time headimgTime, ").append("ac.c_user_name username, ").append("ac.c_email email, ").append("ac.n_time time, ").append("ac.n_audit_time auditTime, ").append("ac.n_status status, ").append("ac.n_using_status usingStatus, ").append("ac.n_delete_flag deleteFlag, ").append("ac.c_audit_remark auditRemark, ").append("t.n_dev_type devType, ").append("t.c_mobile mobile, ").append("t.n_acc_type accType, ").append("t.c_company_name companyName, ").append("t.c_licence_no licenceNo, ").append("t.n_trade trade,").append("t.n_country country, ").append("t.n_city city, ").append("t.c_org_name orgName, ").append("t.n_grade grade, ").append("t.c_surname surname, ").append("t.c_name name, ").append("t.n_profession profession, ").append("t.c_identity_card identityCard, ").append("t.n_time devTime, ").append("ex.c_cardf_thumb_path cardfThumbPath, ").append("ex.c_cardb_thumb_path cardbThumbPath, ").append("ex.c_cardp_thumb_path cardpThumbPath, ").append("ex.c_cardf_path cardfPath, ").append("ex.c_cardb_path cardbPath, ").append("ex.c_cardp_path cardpPath, ").append("ex.c_licensef_path licensefPath, ").append("ex.c_licenseb_path licensebPath, ").append("ex.c_licensef_thumb_path licensefThumbPath, ").append("ex.c_licenseb_thumb_path licensebThumbPath, ").append("ac.n_audit_id aid ").append("FROM t_dev_account_info ac LEFT JOIN t_dev_info t ON ac.n_id = t.n_dev_acc_id ").append("LEFT JOIN t_dev_extend_info ex ON t.n_dev_acc_id = ex.n_dev_acc_id WHERE ac.n_id = :id ) ta ").append("LEFT JOIN t_sys_user u ON  ta.aid = u.n_id ");
        sqlParameterSource.addValue("id", (Object)id);
        try {
            map = this.queryForMap(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("error  no data ");
        }
        return map;
    }

    public List<Map<String, Object>> list(Integer devType, Integer status, Integer acctType, Long timeStart, Long timeEnd, Long auditTimeStart, Long auditTimeEnd, String keyword, Integer start, Integer pageSize) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT info.n_id id, info.c_email email, info.c_user_name username, info.c_email, info.n_status status, dev.n_dev_type devType, info.n_audit_time auditTime, ").append("dev.n_acc_type accType, sys.c_user_name auditName, temp.appCount appCount  ").append("FROM t_dev_account_info info LEFT JOIN t_dev_info dev ON info.n_id = dev.n_dev_acc_id ").append("LEFT JOIN t_dev_extend_info extend ON dev.n_dev_acc_id = extend.n_dev_acc_id LEFT JOIN t_sys_user sys ON info.n_audit_id = sys.n_id  ").append("LEFT JOIN (SELECT count(app.n_id) appCount, app.n_audit_id auditId, app.n_dev_id devId FROM t_app_info app GROUP BY app.n_dev_id) temp ON info.n_id = temp.devId ").append("WHERE 1=1 ");
        if (devType != null && devType != 0) {
            sqlBuffer.append("AND dev.n_dev_type = :devType ");
            sqlParameterSource.addValue("devType", (Object)devType);
        }
        if (status != null) {
            if (status == 0) {
                sqlBuffer.append(" AND info.n_status in (3,4,5) ");
            } else {
                sqlBuffer.append(" AND info.n_status = :status ");
                sqlParameterSource.addValue("status", (Object)status);
            }
        }
        if (acctType != null && acctType != 0) {
            sqlBuffer.append("AND dev.n_acc_type = :accType ");
            sqlParameterSource.addValue("accType", (Object)acctType);
        }
        if (timeStart != null) {
            sqlBuffer.append("AND info.n_time >= :timeStart ");
            sqlParameterSource.addValue("timeStart", (Object)timeStart);
        }
        if (timeEnd != null) {
            sqlBuffer.append("AND info.n_time <= :timeEnd ");
            sqlParameterSource.addValue("timeEnd", (Object)timeEnd);
        }
        if (auditTimeStart != null) {
            sqlBuffer.append("AND info.n_audit_time >= :auditTimeStart ");
            sqlParameterSource.addValue("auditTimeStart", (Object)auditTimeStart);
        }
        if (auditTimeEnd != null) {
            sqlBuffer.append("AND info.n_audit_time <= :auditTimeEnd ");
            sqlParameterSource.addValue("auditTimeEnd", (Object)auditTimeEnd);
        }
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            sqlBuffer.append(" AND ( info.c_email like '%" + keyword + "%' or info.c_user_name like '%" + keyword + "%' or dev.c_mobile like '%" + keyword + "%' ) ");
        }
        sqlBuffer.append(" AND info.n_delete_flag = 1   ORDER BY info.n_status ASC, info.n_audit_time DESC ");
        sqlBuffer.append(" LIMIT ");
        sqlBuffer.append(" " + start);
        sqlBuffer.append(",");
        sqlBuffer.append(" " + pageSize);
        return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)sqlParameterSource);
    }

    public int count(Integer devType, Integer status, Integer acctType, Long timeStart, Long timeEnd, Long auditTimeStart, Long auditTimeEnd, String keyword, int start, Integer pageSize) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT COUNT(info.n_id)  ").append("FROM t_dev_account_info info LEFT JOIN t_dev_info dev ON info.n_id = dev.n_dev_acc_id ").append("LEFT JOIN t_dev_extend_info extend ON dev.n_dev_acc_id = extend.n_dev_acc_id LEFT JOIN t_sys_user sys ON info.n_audit_id = sys.n_id  ").append("WHERE 1=1 ");
        if (devType != null && devType != 0) {
            sqlBuffer.append("AND dev.n_dev_type = :devType ");
            sqlParameterSource.addValue("devType", (Object)devType);
        }
        if (status != null) {
            if (status == 0) {
                sqlBuffer.append(" AND info.n_status in (3,4,5) ");
            } else {
                sqlBuffer.append(" AND info.n_status = :status ");
                sqlParameterSource.addValue("status", (Object)status);
            }
        }
        if (acctType != null && acctType != 0) {
            sqlBuffer.append("AND dev.n_acc_type = :accType ");
            sqlParameterSource.addValue("accType", (Object)acctType);
        }
        if (timeStart != null) {
            sqlBuffer.append("AND info.n_time >= :timeStart ");
            sqlParameterSource.addValue("timeStart", (Object)timeStart);
        }
        if (timeEnd != null) {
            sqlBuffer.append("AND info.n_time <= :timeEnd ");
            sqlParameterSource.addValue("timeEnd", (Object)timeEnd);
        }
        if (auditTimeStart != null) {
            sqlBuffer.append("AND info.n_audit_time >= :auditTimeStart ");
            sqlParameterSource.addValue("auditTimeStart", (Object)auditTimeStart);
        }
        if (auditTimeEnd != null) {
            sqlBuffer.append("AND info.n_audit_time <= :auditTimeEnd ");
            sqlParameterSource.addValue("auditTimeEnd", (Object)auditTimeEnd);
        }
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            sqlBuffer.append(" AND ( info.c_email like '%" + keyword + "%' or info.c_user_name like '%" + keyword + "%' or dev.c_mobile like '%" + keyword + "%' ) ");
        }
        sqlBuffer.append(" AND info.n_delete_flag = 1 ");
        return this.queryForInt(sqlBuffer.toString(), (SqlParameterSource)sqlParameterSource);
    }

    public Map<String, Object> checkUser(Long id) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT n_status status FROM t_dev_account_info WHERE n_id = :id");
        sqlParameterSource.addValue("id", (Object)id);
        Map map = null;
        try {
            map = this.queryForMap(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
        }
        catch (Exception e) {
            this.logger.error("\u6570\u636e\u672a\u67e5\u8be2\u5230\u6216\u8005\u5185\u90e8\u5f02\u5e38");
        }
        return map;
    }

    public int checkMobile(Long userId, String mobile) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT count(*) count FROM t_dev_info t, t_dev_account_info ac WHERE ac.n_id = t.n_dev_acc_id AND ac.n_delete_flag = 1 AND t.c_mobile = :mobile ").append("AND t.n_dev_acc_id != :userId AND ac.n_id !=:userId ");
        sqlParameterSource.addValue("mobile", (Object)mobile);
        sqlParameterSource.addValue("userId", (Object)userId);
        return this.queryForInt(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
    }

    public int checkCompanyName(Long userId, String companyName) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT count(*) count FROM t_dev_info t, t_dev_account_info ac WHERE ac.n_id = t.n_dev_acc_id AND ac.n_delete_flag = 1 AND t.c_company_name = :companyName ").append("AND t.n_dev_acc_id != :userId AND ac.n_id !=:userId ");
        sqlParameterSource.addValue("companyName", (Object)companyName);
        sqlParameterSource.addValue("userId", (Object)userId);
        return this.queryForInt(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
    }

    public int checkLicenceNo(Long userId, String licenceNo) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT count(*) count FROM t_dev_info t, t_dev_account_info ac WHERE ac.n_id = t.n_dev_acc_id AND ac.n_delete_flag = 1 AND t.c_licence_no = :licenceNo ").append("AND t.n_dev_acc_id != :userId AND ac.n_id !=:userId ");
        sqlParameterSource.addValue("licenceNo", (Object)licenceNo);
        sqlParameterSource.addValue("userId", (Object)userId);
        return this.queryForInt(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
    }

    public int checkOrgName(String orgName) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT count(*) count FROM t_dev_info t, t_dev_account_info ac WHERE ac.n_id = t.n_dev_acc_id AND ac.n_delete_flag = 1 AND t.c_org_name = :orgName");
        sqlParameterSource.addValue("orgName", (Object)orgName);
        return this.queryForInt(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
    }

    public int save(Long id) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("UPDATE t_dev_account_info SET n_status = 3 , n_time = :time WHERE n_id = :id ");
        sqlParameterSource.addValue("id", (Object)id);
        sqlParameterSource.addValue("time", (Object)System.currentTimeMillis());
        return this.executeSql(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
    }

    public int upgrade(Long id, Integer accType, int oldAccType) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("UPDATE t_dev_info SET n_acc_type = :accType  WHERE n_dev_acc_id = :id AND n_acc_type = :oldAccType ");
        sqlParameterSource.addValue("id", (Object)id);
        sqlParameterSource.addValue("accType", (Object)accType);
        sqlParameterSource.addValue("oldAccType", (Object)oldAccType);
        return this.executeSql(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
    }

    public Map<String, Object> findDeveloperEmail(Long id) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT t.c_email email FROM t_dev_account_info t WHERE t.n_id = :id");
        sqlParameterSource.addValue("id", (Object)id);
        Map map = null;
        try {
            map = this.queryForMap(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
        }
        catch (Exception e) {
            this.logger.error("\u6570\u636e\u672a\u67e5\u8be2\u5230\u6216\u8005\u5185\u90e8\u5f02\u5e38");
        }
        return map;
    }

    public String queryMailById(Long id) {
        String sql = "SELECT c_email FROM t_dev_account_info WHERE n_id =:id ";
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("id", (Object)id);
        Map map = this.queryForMap(sql, (SqlParameterSource)sqlParameterSource);
        if (null != map.get("c_email") && StringUtils.isNotBlank((CharSequence)map.get("c_email").toString())) {
            return map.get("c_email").toString();
        }
        return "";
    }

    public int checkIdentityCardIsExist(Long id, String identityCard) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT count(*) count FROM t_dev_info t, t_dev_account_info ac WHERE ac.n_id = t.n_dev_acc_id AND ac.n_delete_flag = 1 AND t.c_identity_card = :identityCard ").append("AND t.n_dev_acc_id != :userId AND ac.n_id !=:userId ");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("identityCard", (Object)identityCard);
        sqlParameterSource.addValue("userId", (Object)id);
        return this.queryForInt(sqlBuilder.toString(), (SqlParameterSource)sqlParameterSource);
    }

    public Map<String, Object> getUserRegisterInfo(Long id, Integer devType) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT info.c_name name, info.c_identity_card identityCard, info.c_mobile mobile, ").append("info.n_country country, info.n_city city, info.n_trade trade, info.n_profession profession, ").append("info.c_company_name companyName, info.c_org_name orgName, info.c_licence_no licenceNo, ").append("extend.c_cardb_path cardb_path, extend.c_cardf_path cardf_path, extend.c_cardp_path cardp_path, ").append("extend.c_licensef_path licensef_path, extend.c_licenseb_path licenseb_path, info.n_time time  ").append("FROM t_dev_info info LEFT JOIN t_dev_extend_info extend ON info.n_dev_acc_id = extend.n_dev_acc_id  ").append("WHERE info.n_dev_acc_id = :id ");
        if (null != devType) {
            sqlBuffer.append("AND n_dev_type = :devType ");
            sqlParam.addValue("devType", (Object)devType);
        }
        sqlParam.addValue("id", (Object)id);
        return this.queryForMap(sqlBuffer.toString(), (SqlParameterSource)sqlParam);
    }

    public List<Map<String, Object>> queryAllAdminEmail() {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        String sql = "SELECT c_email email FROM t_sys_user ";
        return this.queryForList(sql, (SqlParameterSource)sqlParam);
    }
}

