/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.developer.service.impl;

import com.xdja.cssp.open.core.util.Hamcsha1Utils;
import com.xdja.cssp.open.core.util.SmsUtil;
import com.xdja.cssp.open.developer.business.DeveloperInfoBusiness;
import com.xdja.cssp.open.developer.cache.MobileCodeCache;
import com.xdja.cssp.open.developer.dao.DeveloperInfoDao;
import com.xdja.cssp.open.service.developer.service.DeveloperInfoService;
import com.xdja.cssp.open.utils.Constants;
import com.xdja.cssp.open.utils.MailUtil;
import com.xdja.cssp.open.utils.ResultStatus;
import com.xdja.platform.redis.core.RedisClient;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeveloperInfoServiceImpl
implements DeveloperInfoService {
    private static final Logger logger = LoggerFactory.getLogger(DeveloperInfoServiceImpl.class);
    @Resource
    DeveloperInfoBusiness developerInfoBusiness;
    @Resource
    RedisClient redisClient;
    @Resource
    MobileCodeCache mobileCodeCache;
    @Resource
    DeveloperInfoDao developerInfoDao;

    public int auditDeveloper(Long id, Integer status, String auditRemark, Long userid) {
        return this.developerInfoBusiness.auditDeveloper(id, status, auditRemark, userid);
    }

    public Map<String, Object> findDeveloperById(Long id) {
        return this.developerInfoBusiness.findDeveloperById(id);
    }

    public List<Map<String, Object>> list(Integer devType, Integer status, Integer acctType, Long timeStart, Long timeEnd, Long auditTimeStart, Long auditTimeEnd, String keyword, Integer pageNo, Integer pageSize) {
        int start = (pageNo - 1) * pageSize;
        return this.developerInfoBusiness.list(devType, status, acctType, timeStart, timeEnd, auditTimeStart, auditTimeEnd, keyword, start, pageSize);
    }

    public long count(Integer devType, Integer status, Integer acctType, Long timeStart, Long timeEnd, Long auditTimeStart, Long auditTimeEnd, String keyword, Integer pageNo, Integer pageSize) {
        int start = (pageNo - 1) * pageSize;
        return this.developerInfoBusiness.count(devType, status, acctType, timeStart, timeEnd, auditTimeStart, auditTimeEnd, keyword, start, pageSize);
    }

    public Map<String, Object> checkUser(Long id) {
        return this.developerInfoBusiness.checkUser(id);
    }

    public int checkMobile(Long userId, String mobile) {
        return this.developerInfoBusiness.checkMobile(userId, mobile);
    }

    public int checkCompanyName(Long userId, String companyName) {
        return this.developerInfoBusiness.checkCompanyName(userId, companyName);
    }

    public int checkLicenceNo(Long userId, String licenceNo) {
        return this.developerInfoBusiness.checkLicenceNo(userId, licenceNo);
    }

    public int checkOrgName(String orgName) {
        return this.developerInfoBusiness.checkOrgName(orgName);
    }

    public int save(Long id, Integer devType, String surname, String name, String mobile, String validateCode, String country, String city, String trade, String profession, String string, String string2, String string3, String companyName, String licenceNo, String string4, String string5, String orgName, int accType, String identityCard) {
        int n = 0;
        if (null != devType && devType != 2 && (n = this.mobileCodeCache.getMobileCodeInfo(id, mobile, validateCode)) != 0) {
            return n;
        }
        try {
            n = this.developerInfoBusiness.save(id, devType, surname, name, mobile, validateCode, country, city, trade, profession, string, string2, string3, companyName, licenceNo, string4, string5, orgName, accType, identityCard);
            this.mobileCodeCache.delMobileCode(id, validateCode);
            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            String dateStr = df.format(new Date());
            StringBuffer strBuffer = new StringBuffer().append(Constants.PASS_NOTICE_EMAIL_CONTENT1).append(Constants.PASS_NOTICE_EMAIL_CONTENT2);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                strBuffer.append(name);
            } else {
                strBuffer.append(companyName);
            }
            strBuffer.append(Constants.PASS_NOTICE_EMAIL_CONTENT3).append(Constants.COMMON_MAIL_CONTENT1).append(dateStr).append(Constants.COMMON_MAIL_CONTENT2);
            List<Map<String, Object>> emailList = this.developerInfoDao.queryAllAdminEmail();
            if (null == emailList || emailList.size() == 0) {
                logger.error("\u7528\u6237\u7533\u8bf7\u5f00\u53d1\u8005\uff0c\u6ca1\u6709\u627e\u5230\u7ba1\u7406\u5458\u90ae\u7bb1\u53d1\u9001\u901a\u77e5\u90ae\u4ef6");
            } else {
                for (Map<String, Object> map : emailList) {
                    String toEmail;
                    if (null == map.get("email") || !StringUtils.isNotBlank((CharSequence)(toEmail = map.get("email").toString()))) continue;
                    MailUtil.sendHTMLMail((String)Constants.FROM_MAIL_ADDRESS, (String)toEmail, (String)Constants.PASS_NOTICE_EMAIL_SUBJECT, (String)strBuffer.toString());
                }
            }
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 5;
        }
    }

    public int upgrade(Long id, Integer accType, int oldAccType) {
        return this.developerInfoBusiness.upgrade(id, accType, oldAccType);
    }

    public Map<String, Object> findDeveloperEmail(Long id) {
        return this.developerInfoBusiness.findDeveloperEmail(id);
    }

    public Map<String, Object> sendSMSCode(Long userId, String code, String mobile, String validateCode) {
        Map<String, Object> result = new HashMap<String, Object>();
        result.put("result", "validateCodeError");
        String cacheValidateCode = this.redisClient.get("open_validate_code_" + mobile);
        if (StringUtils.isBlank((CharSequence)cacheValidateCode)) {
            result.put("message", "\u9a8c\u8bc1\u7801\u8fc7\u671f");
        } else if (!cacheValidateCode.equalsIgnoreCase(validateCode)) {
            result.put("message", "\u9a8c\u8bc1\u7801\u9519\u8bef");
        } else {
            result = this.mobileCodeCache.addMobileCode(userId, mobile, code);
            String flag = (String)result.get("result");
            System.out.println(flag);
            if (flag.equals("success")) {
                ResultStatus rs = SmsUtil.send((String)mobile, (String)Constants.PHONE_IDENTIFY_ID, (String[])new String[]{code});
                logger.debug("\u53d1\u9001\u77ed\u4fe1\u8fd4\u56de\u7801\u4e3a\uff1a \u9884\u8bbe\u53d1\u9001\u77ed\u4fe1\u8fd4\u56de\u7801\u4e3a\uff1a" + ResultStatus.SUCCESS.code);
                if (rs != ResultStatus.SUCCESS) {
                    result.put("message", "\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\uff01");
                    logger.error("\u5411\u7528\u6237\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25,\u7528\u6237\u7535\u8bdd\u4e3a\uff1a" + mobile);
                    throw new RuntimeException("\u5411\u7528\u6237\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25,\u7528\u6237\u7535\u8bdd\u4e3a\uff1a" + mobile);
                }
            }
        }
        return result;
    }

    public int checkIdentityCardIsExist(Long id, String identityCard) {
        return this.developerInfoBusiness.checkIdentityCardIsExist(id, identityCard);
    }

    public int checkSMSCode(Long id, String mobile, String validateCode) {
        return this.mobileCodeCache.getMobileCodeInfo(id, mobile, validateCode);
    }

    public Map<String, Object> getUserRegisterInfo(Long id, Integer devType) {
        return this.developerInfoBusiness.getUserRegisterInfo(id, devType);
    }

    public String getUploadPicUrl(String fileUrl, Integer trunk, Boolean https) throws InvalidKeyException, NumberFormatException, NoSuchAlgorithmException {
        String str = this.getFileURL(Constants.FILE_UPLOAD_TIMEOUT, fileUrl);
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            String param = "upload";
            if (null != trunk && trunk == 2) {
                param = "trunkform";
            }
            if (https.booleanValue()) {
                return "https://" + Constants.FILE_SERVER_IP + ":" + Constants.FILE_HTTPS_PORT + "/" + param + "?userid=" + Constants.FILE_SERVER_USERID + "&" + str;
            }
            return "http://" + Constants.FILE_SERVER_IP + ":" + Constants.FILE_HTTP_PORT + "/" + param + "?userid=" + Constants.FILE_SERVER_USERID + "&" + str;
        }
        if (https.booleanValue()) {
            return "https://" + Constants.FILE_SERVER_IP + ":" + Constants.FILE_HTTPS_PORT + "/" + fileUrl + "?" + str;
        }
        return "http://" + Constants.FILE_SERVER_IP + ":" + Constants.FILE_HTTP_PORT + "/" + fileUrl + "?" + str;
    }

    public String getFileURL(Long timeout, String fileUrl) throws InvalidKeyException, NoSuchAlgorithmException {
        long time = new Date().getTime() + timeout;
        String key = Constants.FILE_SERVER_USERSECRET;
        String data = "";
        data = StringUtils.isBlank((CharSequence)fileUrl) ? Constants.FILE_SERVER_USERID + time : fileUrl + time;
        String sign = Hamcsha1Utils.hamcsha1((String)data, (String)key);
        return "ts=" + time + "&sign=" + sign;
    }
}

