/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.util;

import com.xdja.cssp.open.system.util.XmlOperation;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureUtil {
    protected static final transient Logger LOGGER = LoggerFactory.getLogger(ConfigureUtil.class);
    private static XmlOperation xmloInstance;
    private static Map<String, Map<String, Object>> idValues;
    private static String systemRes;
    private static Map<String, Object> rootConf;

    public static void reload() {
        ConfigureUtil.init();
    }

    public static void update(String id, String value) {
        Document doc = xmloInstance.getDoc();
        ConfigureUtil.update(doc, (String)idValues.get(id).get("xpath"), value);
        xmloInstance.saveXmlString(doc.asXML());
        ConfigureUtil.reload();
    }

    public static Map<String, Object> getRootConf() {
        rootConf.put("open", true);
        return rootConf;
    }

    public static Map<String, Object> getRootConf(Document doc) {
        HashMap<String, Object> rootConf = new HashMap<String, Object>();
        rootConf.put("open", true);
        if (doc != null) {
            ConfigureUtil.iterateElement(doc.getRootElement(), rootConf, null);
        }
        return rootConf;
    }

    public static Document xmlStr2Doc(String xmlStr) {
        Document doc = DocumentHelper.createDocument();
        if (StringUtils.isNotBlank((CharSequence)xmlStr)) {
            try {
                doc = new SAXReader().read((InputStream)new ByteArrayInputStream(xmlStr.getBytes("utf-8")));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("\u89e3\u6790xml\u5931\u8d25", (Throwable)e);
            }
            catch (DocumentException e) {
                LOGGER.error("\u89e3\u6790xml\u5931\u8d25", (Throwable)e);
            }
        }
        return doc;
    }

    public static void update(Document doc, String xpath, String value) {
        Node node = doc.selectSingleNode(xpath);
        Element elem = (Element)node;
        elem.attribute("value").setValue(value);
    }

    private static void init() {
        if (xmloInstance != null) {
            xmloInstance = null;
        }
        try {
            xmloInstance = new XmlOperation(URLDecoder.decode(ConfigureUtil.class.getResource(systemRes).getFile(), "UTF-8"));
            LOGGER.info("\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u6210\u529f");
            ConfigureUtil.loadIdValues();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void loadIdValues() {
        if (idValues != null) {
            idValues.clear();
        } else {
            idValues = new HashMap<String, Map<String, Object>>();
        }
        ConfigureUtil.iterateElement(xmloInstance.getDoc().getRootElement(), rootConf, idValues);
    }

    private static void iterateElement(Element element, Map<String, Object> parentConf, Map<String, Map<String, Object>> idValues) {
        if (element == null) {
            return;
        }
        String id = element.attributeValue("id");
        String value = element.attributeValue("value");
        if (id != null) {
            LOGGER.info(id + "=" + value);
            String string = value = value == null ? "" : value;
            if (idValues != null) {
                idValues.put(id, parentConf);
            }
            parentConf.put("id", id);
            parentConf.put("value", value);
        }
        parentConf.put("regstr", element.attributeValue("regstr"));
        parentConf.put("label", element.attributeValue("label"));
        parentConf.put("desc", element.attributeValue("description"));
        parentConf.put("xpath", element.getPath());
        ArrayList<HashMap<String, Object>> children = new ArrayList<HashMap<String, Object>>();
        parentConf.put("children", children);
        Iterator elementChildren = element.elementIterator();
        while (elementChildren.hasNext()) {
            HashMap<String, Object> confMap = new HashMap<String, Object>();
            children.add(confMap);
            Element elementChild = (Element)elementChildren.next();
            ConfigureUtil.iterateElement(elementChild, confMap, idValues);
        }
    }

    public static String getValueById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.error("id\u662f\u7a7a\u3002");
            return "";
        }
        if (idValues == null) {
            LOGGER.error("idValues\u4e3a\u7a7a\u3002");
            return "";
        }
        String value = (String)idValues.get(id).get("value");
        if (StringUtils.isBlank((CharSequence)value)) {
            LOGGER.warn("id\u662f" + id + "\u7684\u5bf9\u5e94value\u4e0d\u5b58\u5728\u3002");
            return "";
        }
        LOGGER.info("id\u662f" + id + "\u7684\u5bf9\u5e94value\u662f" + value);
        return value;
    }

    public static String getValueByXpath(String xpath) {
        if (StringUtils.isBlank((CharSequence)xpath)) {
            LOGGER.error("xpath\u662f\u7a7a");
            return "";
        }
        String value = xmloInstance.getValueByXpath(xpath);
        if (StringUtils.isBlank((CharSequence)value)) {
            LOGGER.warn("xpath\u662f" + xpath + "\u7684\u5bf9\u5e94value\u4e0d\u5b58\u5728");
            return "";
        }
        LOGGER.info("xpath\u662f" + xpath + "\u7684\u5bf9\u5e94value\u662f" + value);
        return value;
    }

    static {
        systemRes = "/System.xml";
        rootConf = new HashMap<String, Object>();
        ConfigureUtil.init();
    }
}

