/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.cache;

import com.xdja.cssp.open.system.entity.OpenApp;
import com.xdja.platform.redis.core.RedisClient;
import com.xdja.platform.redis.core.action.JedisAction;
import com.xdja.platform.redis.core.action.JedisActionNoResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Component
public class AppInfoCache {
    @Resource
    private RedisClient redisClient;
    private static final String APPINFO_PREFIX = "open_app_info_";

    public void addAppInfo(final OpenApp ... appInfos) {
        if (null != appInfos && appInfos.length > 0) {
            this.redisClient.execute(new JedisActionNoResult(){

                public void action(Jedis jedis) {
                    Pipeline p = jedis.pipelined();
                    HashMap<String, String> item = null;
                    OpenApp info = null;
                    for (int i = 0; i < appInfos.length; ++i) {
                        info = appInfos[i];
                        if (null == info) continue;
                        item = new HashMap<String, String>();
                        item.put("appId", info.getAppId());
                        item.put("name", info.getName());
                        item.put("secretKey", info.getSecretKey());
                        item.put("pkgName", info.getPkgName());
                        item.put("pkgSign", info.getPkgSign());
                        item.put("suit", 0 == info.getSuit() ? "" : String.valueOf(info.getSuit()));
                        item.put("type", String.valueOf(info.getType()));
                        item.put("time", String.valueOf(info.getTime()));
                        item.put("copyright", info.getCopyright());
                        item.put("interVersion", info.getInterVersion());
                        item.put("pkgHashVal", info.getPkgHashVal());
                        item.put("token", info.getToken());
                        item.put("version", StringUtils.isBlank((CharSequence)info.getVersion()) ? "" : String.valueOf(info.getVersion()));
                        item.put("kdcSuit", null == info.getKdcSuit() ? "" : String.valueOf(info.getKdcSuit()));
                        item.put("kdcAuthType", 0 == info.getKdcAuthType() ? "" : String.valueOf(info.getKdcAuthType()));
                        item.put("kdcVersion", StringUtils.isBlank((CharSequence)info.getKdcVersion()) ? "" : info.getKdcVersion());
                        item.put("kdcSignature", StringUtils.isBlank((CharSequence)info.getKdcSignature()) ? "" : info.getKdcSignature());
                        p.hmset(AppInfoCache.APPINFO_PREFIX + info.getAppId(), item);
                    }
                    p.sync();
                }
            });
        }
    }

    public void addAppInfoByAppidPackageName(OpenApp ... appInfos) {
    }

    public OpenApp getAppInfo(final String appId) {
        return (OpenApp)this.redisClient.execute((JedisAction)new JedisAction<OpenApp>(){

            public OpenApp action(Jedis jedis) {
                OpenApp info = null;
                Map data = jedis.hgetAll(AppInfoCache.APPINFO_PREFIX + appId);
                if (null != data && !data.isEmpty()) {
                    info = new OpenApp();
                    info.setAppId((String)data.get("appId"));
                    info.setName((String)data.get("name"));
                    info.setSecretKey((String)data.get("secretKey"));
                    info.setPkgName((String)data.get("pkgName"));
                    info.setPkgSign((String)data.get("pkgSign"));
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("suit")))) {
                        info.setSuit(Integer.parseInt((String)data.get("suit")));
                    }
                    info.setType(Integer.parseInt((String)data.get("type")));
                    info.setTime(Long.parseLong((String)data.get("time")));
                    info.setCopyright((String)data.get("copyright"));
                    info.setInterVersion((String)data.get("interVersion"));
                    info.setPkgHashVal((String)data.get("pkgHashVal"));
                    info.setToken((String)data.get("token"));
                    info.setVersion((String)data.get("version"));
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("kdcSuit")))) {
                        info.setKdcSuit(Long.valueOf((String)data.get("kdcSuit")));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("kdcAuthType")))) {
                        info.setKdcAuthType(Integer.parseInt((String)data.get("kdcAuthType")));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("kdcVersion")))) {
                        info.setKdcVersion((String)data.get("kdcVersion"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("kdcSignature")))) {
                        info.setKdcSignature((String)data.get("kdcSignature"));
                    }
                }
                return info;
            }
        });
    }

    public Map<String, OpenApp> getAppInfoBatch(final String ... appIds) {
        return (Map)this.redisClient.execute((JedisAction)new JedisAction<Map<String, OpenApp>>(){

            public Map<String, OpenApp> action(Jedis jedis) {
                HashMap<String, OpenApp> result = new HashMap<String, OpenApp>();
                HashMap<String, Response> responses = new HashMap<String, Response>();
                Map data = null;
                OpenApp appInfo = null;
                Pipeline p = jedis.pipelined();
                for (int i = 0; i < appIds.length; ++i) {
                    String key = AppInfoCache.APPINFO_PREFIX + appIds[i];
                    responses.put(key, p.hgetAll(key));
                }
                p.sync();
                for (Map.Entry item : responses.entrySet()) {
                    data = (Map)((Response)item.getValue()).get();
                    if (null == data || data.isEmpty()) continue;
                    appInfo = new OpenApp();
                    appInfo.setAppId((String)data.get("appId"));
                    appInfo.setName((String)data.get("name"));
                    appInfo.setSecretKey((String)data.get("secretKey"));
                    appInfo.setPkgName((String)data.get("pkgName"));
                    appInfo.setPkgSign((String)data.get("pkgSign"));
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("suit")))) {
                        appInfo.setSuit(Integer.parseInt((String)data.get("suit")));
                    }
                    appInfo.setType(Integer.parseInt((String)data.get("type")));
                    appInfo.setTime(Long.parseLong((String)data.get("time")));
                    appInfo.setCopyright((String)data.get("copyright"));
                    appInfo.setInterVersion((String)data.get("interVersion"));
                    appInfo.setPkgHashVal((String)data.get("pkgHashVal"));
                    appInfo.setToken((String)data.get("token"));
                    appInfo.setVersion((String)data.get("version"));
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("kdcSuit")))) {
                        appInfo.setKdcSuit(Long.valueOf((String)data.get("kdcSuit")));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("kdcAuthType")))) {
                        appInfo.setKdcAuthType(Integer.parseInt((String)data.get("kdcAuthType")));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("kdcVersion")))) {
                        appInfo.setKdcVersion((String)data.get("kdcVersion"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)data.get("kdcSignature")))) {
                        appInfo.setKdcSignature((String)data.get("kdcSignature"));
                    }
                    result.put(appInfo.getAppId(), appInfo);
                }
                return result;
            }
        });
    }

    public List<OpenApp> getAppInfoBatch(List<Map<String, String>> appIdPackages) {
        return null;
    }

    public void delAppInfo(String appId) {
        this.redisClient.del(new String[]{APPINFO_PREFIX + appId});
    }
}

