/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.dao;

import com.xdja.cssp.open.system.entity.TAccountInfo;
import com.xdja.cssp.open.system.util.DateQueryBean;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import com.xdja.platform.datacenter.jpa.dao.helper.BeanRowMapper;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TAccountInfoDao
extends BaseJpaDao<TAccountInfo, Long> {
    public void register(String email, String password, Long createTime, String activeCode, Long tokenExptime) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer("INSERT INTO t_dev_account_info(").append("c_password, c_email, n_time, c_active_code, c_token_exptime)").append("values").append("(:password, :email, :time, :activeCode, :tokenExptime)");
        if (StringUtils.isNotBlank((CharSequence)password)) {
            sqlParam.addValue("password", (Object)password);
        }
        if (StringUtils.isNotBlank((CharSequence)email)) {
            sqlParam.addValue("email", (Object)email);
        }
        if (null != createTime) {
            sqlParam.addValue("time", (Object)createTime);
        }
        if (StringUtils.isNotBlank((CharSequence)activeCode)) {
            sqlParam.addValue("activeCode", (Object)activeCode);
        }
        if (null != tokenExptime) {
            sqlParam.addValue("tokenExptime", (Object)tokenExptime);
        }
        this.executeSql(sqlBuffer.toString(), (SqlParameterSource)sqlParam);
    }

    public TAccountInfo getAccountInfoByAccountId(Long accountId) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT").append(" accountInfo.n_id AS id,").append(" accountInfo.c_user_name AS username,").append(" accountInfo.c_password AS password,").append(" accountInfo.c_email AS email,").append(" accountInfo.n_delete_flag AS deleteFlag,").append(" accountInfo.n_using_status AS usingStatus,").append(" accountInfo.n_status AS status,").append(" accountInfo.n_time AS time,").append(" accountInfo.n_audit_time AS auditTime,").append(" accountInfo.n_audit_id AS auditId,").append(" accountInfo.c_reset_time AS resetTime, ").append(" accountInfo.n_headimg headImg ").append(" FROM t_dev_account_Info accountInfo").append(" WHERE 1=1").append(" AND accountInfo.n_id = :accountId");
        sqlParam.addValue("accountId", (Object)accountId);
        System.out.println(sqlBuilder);
        TAccountInfo accountInfo = (TAccountInfo)this.queryForObject(sqlBuilder.toString(), (SqlParameterSource)sqlParam, (RowMapper)new BeanRowMapper(TAccountInfo.class));
        return accountInfo;
    }

    public void resetPwd(Long accountId, String password) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuffer sqlbuffer = new StringBuffer("UPDATE t_dev_account_info AS accountInfo SET");
        if (StringUtils.isNotBlank((CharSequence)password)) {
            sqlbuffer.append(" accountInfo.c_password = :password");
            sqlParam.addValue("password", (Object)password);
        }
        sqlbuffer.append(" WHERE 1=1").append(" AND accountInfo.n_id = :accountId");
        sqlParam.addValue("accountId", (Object)accountId);
        this.addOrUpdate(sqlbuffer.toString(), new SqlParameterSource[]{sqlParam});
    }

    public void resetPwd(String email, String password) {
        try {
            MapSqlParameterSource sqlParam = new MapSqlParameterSource();
            StringBuffer sqlbuffer = new StringBuffer("UPDATE t_dev_account_info AS accountInfo SET");
            sqlbuffer.append(" accountInfo.c_password = :password");
            sqlbuffer.append(" WHERE 1=1").append(" AND accountInfo.c_email = :email");
            if (StringUtils.isNotBlank((CharSequence)password)) {
                sqlParam.addValue("password", (Object)password);
            }
            if (StringUtils.isNotBlank((CharSequence)password)) {
                sqlParam.addValue("email", (Object)email);
            }
            this.addOrUpdate(sqlbuffer.toString(), new SqlParameterSource[]{sqlParam});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateAccountStatus(Integer status, String email) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuffer sqlbuffer = new StringBuffer("UPDATE t_dev_account_info AS accountInfo SET");
        sqlbuffer.append(" accountInfo.n_status = :status,").append(" accountInfo.n_activate_time = :activateTime ").append(" WHERE 1=1").append(" AND accountInfo.c_email = :email");
        if (null != status) {
            sqlParam.addValue("status", (Object)status);
        }
        if (StringUtils.isNotBlank((CharSequence)email)) {
            sqlParam.addValue("email", (Object)email);
        }
        sqlParam.addValue("activateTime", (Object)System.currentTimeMillis());
        try {
            this.addOrUpdate(sqlbuffer.toString(), new SqlParameterSource[]{sqlParam});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void forbiddenUser(Long accountId, Integer status) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuffer sqlbuffer = new StringBuffer("UPDATE t_dev_account_info AS accountInfo SET");
        if (null != status) {
            sqlbuffer.append(" accountInfo.n_using_status = :status");
            sqlParam.addValue("status", (Object)status);
        }
        sqlbuffer.append(" WHERE 1=1").append(" AND accountInfo.n_id = :accountId");
        sqlParam.addValue("accountId", (Object)accountId);
        this.addOrUpdate(sqlbuffer.toString(), new SqlParameterSource[]{sqlParam});
    }

    public void deleteUser(Long accountId, Integer status) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuffer sqlbuffer = new StringBuffer("UPDATE t_dev_account_info AS accountInfo SET");
        if (null != status) {
            sqlbuffer.append(" accountInfo.n_delete_flag = :status");
            sqlParam.addValue("status", (Object)status);
        }
        sqlbuffer.append(" WHERE 1=1").append(" AND accountInfo.n_id = :accountId");
        sqlParam.addValue("accountId", (Object)accountId);
        this.addOrUpdate(sqlbuffer.toString(), new SqlParameterSource[]{sqlParam});
    }

    public TAccountInfo getActiveCodeByEmail(String email) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT accountInfo.n_id id, ");
        sqlBuilder.append(" accountInfo.c_active_code AS activeCode,").append(" accountInfo.c_token_exptime AS tokenExptime,").append(" accountInfo.c_email AS email,").append(" accountInfo.n_status AS status,").append(" accountInfo.n_time AS time").append(" FROM").append(" t_dev_account_info accountInfo").append(" WHERE 1=1");
        if (StringUtils.isNotBlank((CharSequence)email)) {
            sqlBuilder.append(" AND accountInfo.c_email = :email");
        }
        sqlParam.addValue("email", (Object)email);
        return (TAccountInfo)this.queryForObject(sqlBuilder.toString(), (SqlParameterSource)sqlParam, (RowMapper)new BeanRowMapper(TAccountInfo.class));
    }

    public List<TAccountInfo> ajaxAccountInfoList(Long pageNum, int pageSize, TAccountInfo condition, DateQueryBean queryBean) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder("SELECT").append(" accountInfo.n_id AS id,").append(" accountInfo.c_user_name AS userName,").append(" accountInfo.c_email AS email,").append(" accountInfo.n_time AS time,").append(" accountInfo.n_using_status AS status").append(" FROM").append(" t_dev_account_info accountInfo WHERE 1=1 ");
        if (null != condition && StringUtils.isNotBlank((CharSequence)condition.getKeyWord())) {
            String keyWord = condition.getKeyWord().replaceAll("%", "/%").replaceAll("_", "/_");
            sql.append(" AND (accountInfo.c_user_name LIKE :keyWord ESCAPE '/'").append(" OR accountInfo.c_email LIKE :keyWord ESCAPE '/')");
            sqlParam.addValue("keyWord", (Object)("%" + keyWord + "%"));
        }
        if (null != queryBean) {
            if (null != queryBean.getTimeStart()) {
                sql.append(" AND accountInfo.n_time >= :startTime");
                sqlParam.addValue("startTime", (Object)queryBean.getTimeStart());
            }
            if (null != queryBean.getTimeEnd()) {
                sql.append(" AND accountInfo.n_time <= :endTime");
                sqlParam.addValue("endTime", (Object)queryBean.getTimeEnd());
            }
        }
        sql.append(" AND accountInfo.n_delete_flag = 1 ").append(" AND (accountInfo.n_status = 1 OR accountInfo.n_status = 2) ");
        sql.append(" ORDER BY accountInfo.n_time DESC ");
        Long start = (pageNum - 1L) * (long)pageSize;
        sql.append(" LIMIT " + start + "," + pageSize);
        return this.queryForList(sql.toString(), (SqlParameterSource)sqlParam, (RowMapper)new BeanRowMapper(TAccountInfo.class));
    }

    public Long getCountInfo(Long pageNum, int pageSize, TAccountInfo condition, DateQueryBean queryBean) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder("SELECT COUNT(n_id)").append(" FROM").append(" t_dev_account_info accountInfo WHERE 1=1 ");
        if (null != condition && StringUtils.isNotBlank((CharSequence)condition.getKeyWord())) {
            String keyWord = condition.getKeyWord().replaceAll("%", "/%").replaceAll("_", "/_");
            sql.append(" AND (accountInfo.c_user_name LIKE :keyWord ESCAPE '/'").append(" OR accountInfo.c_email LIKE :keyWord ESCAPE '/')");
            sqlParam.addValue("keyWord", (Object)("%" + keyWord + "%"));
        }
        if (null != queryBean) {
            if (null != queryBean.getTimeStart()) {
                sql.append(" AND accountInfo.n_time >= :startTime");
                sqlParam.addValue("startTime", (Object)queryBean.getTimeStart());
            }
            if (null != queryBean.getTimeEnd()) {
                sql.append(" AND accountInfo.n_time <= :endTime");
                sqlParam.addValue("endTime", (Object)queryBean.getTimeEnd());
            }
        }
        sql.append(" AND accountInfo.n_delete_flag = 1").append(" AND (accountInfo.n_status = 1 OR accountInfo.n_status = 2) ");
        return this.queryForLong(sql.toString(), (SqlParameterSource)sqlParam);
    }

    public TAccountInfo getAccountInfoByEmail(String email) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT");
        sqlBuilder.append(" accountInfo.n_id AS id,").append(" accountInfo.c_user_name AS userName,").append(" accountInfo.c_password AS password,").append(" accountInfo.c_email AS email,").append(" accountInfo.n_delete_flag AS deleteFlag,").append(" accountInfo.n_using_status AS usingStatus,").append(" accountInfo.n_status AS status,").append(" accountInfo.n_time AS time,").append(" accountInfo.n_audit_time AS auditTime,").append(" accountInfo.n_audit_id AS auditId,").append(" accountInfo.c_audit_remark AS auditRemark,").append(" accountInfo.c_active_code AS activeCode,").append(" accountInfo.c_token_exptime AS tokenExptime,").append(" accountInfo.c_reset_code AS resetCode,").append(" accountInfo.c_reset_time AS resetTime,").append(" accountInfo.n_headimg AS headImg,").append(" accountInfo.n_updatenic_times AS updatenicTimes,").append(" devInfo.n_acc_type AS accType").append(" FROM t_dev_account_info accountInfo").append(" LEFT JOIN").append(" t_dev_info devInfo ON devInfo.n_dev_acc_id = accountInfo.n_id").append(" WHERE 1=1");
        if (StringUtils.isNotBlank((CharSequence)email)) {
            sqlBuilder.append(" AND accountInfo.c_email = :email");
            sqlParam.addValue("email", (Object)email);
        }
        return (TAccountInfo)this.queryForObject(sqlBuilder.toString(), (SqlParameterSource)sqlParam, (RowMapper)new BeanRowMapper(TAccountInfo.class));
    }

    public TAccountInfo updateAccount(TAccountInfo accountInfo) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("update t_dev_account_info set");
        sqlBuilder.append(" c_email = :email,").append(" n_id = id,").append(" c_password = :password,").append(" n_delete_flag = :deleteFlag,").append(" n_using_status = :usingStatus,").append(" n_status = :status,").append(" n_time = :time,").append(" n_audit_time = :auditTime,").append(" n_audit_id = :auditId,").append(" c_audit_remark = :auditRemark,").append(" c_active_code = :activeCode,").append(" c_token_exptime = :tokenExptime,").append(" c_reset_code = :resetCode,").append(" c_reset_time = :resetTime,").append(" n_headimg = :headImg,").append(" n_updatenic_times = :updatenicTimes,").append(" WHERE 1=1");
        if (StringUtils.isNotBlank((CharSequence)accountInfo.getEmail())) {
            sqlParam.addValue("email", (Object)accountInfo.getEmail());
        }
        if (null != accountInfo.getId()) {
            sqlParam.addValue("id", (Object)accountInfo.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)accountInfo.getPassword())) {
            sqlParam.addValue("password", (Object)accountInfo.getPassword());
        }
        if (null != accountInfo.getDeleteFlag()) {
            sqlParam.addValue("deleteFlag", (Object)accountInfo.getDeleteFlag());
        }
        if (null != accountInfo.getUsingStatus()) {
            sqlParam.addValue("usingStatus", (Object)accountInfo.getUsingStatus());
        }
        if (null != accountInfo.getStatus()) {
            sqlParam.addValue("status", (Object)accountInfo.getStatus());
        }
        if (null != accountInfo.getTime()) {
            sqlParam.addValue("time", (Object)accountInfo.getTime());
        }
        if (null != accountInfo.getAuditTime()) {
            sqlParam.addValue("auditTime", (Object)accountInfo.getAuditTime());
        }
        if (null != accountInfo.getAuditId()) {
            sqlParam.addValue("auditId", (Object)accountInfo.getAuditId());
        }
        if (StringUtils.isNotBlank((CharSequence)accountInfo.getAuditRemark())) {
            sqlParam.addValue("auditRemark", (Object)accountInfo.getAuditRemark());
        }
        if (StringUtils.isNotBlank((CharSequence)accountInfo.getActiveCode())) {
            sqlParam.addValue("activeCode", (Object)accountInfo.getActiveCode());
        }
        return (TAccountInfo)this.queryForObject(sqlBuilder.toString(), (SqlParameterSource)sqlParam, (RowMapper)new BeanRowMapper(TAccountInfo.class));
    }

    public void resendActivate(String activeCode, Long tokenExptime, String email) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer("UPDATE t_dev_account_info SET").append(" c_active_code = :activeCode,").append(" c_token_exptime = :tokenExptime").append(" WHERE 1=1").append(" AND c_email = :email");
        if (StringUtils.isNotBlank((CharSequence)activeCode)) {
            sqlParam.addValue("activeCode", (Object)activeCode);
        }
        if (null != tokenExptime) {
            sqlParam.addValue("tokenExptime", (Object)tokenExptime);
        }
        if (StringUtils.isNotBlank((CharSequence)email)) {
            sqlParam.addValue("email", (Object)email);
        }
        this.executeSql(sqlBuffer.toString(), (SqlParameterSource)sqlParam);
    }

    public void updateResetPwd(String email, String resetCode, Long resetTime) {
        try {
            MapSqlParameterSource sqlParam = new MapSqlParameterSource();
            StringBuffer sqlBuffer = new StringBuffer("UPDATE t_dev_account_info SET").append(" c_reset_code = :resetCode,").append(" c_reset_time = :resetTime").append(" WHERE 1=1").append(" AND c_email = :email");
            if (StringUtils.isNotBlank((CharSequence)resetCode)) {
                sqlParam.addValue("resetCode", (Object)resetCode);
            }
            if (null != resetTime) {
                sqlParam.addValue("resetTime", (Object)resetTime);
            }
            if (StringUtils.isNotBlank((CharSequence)email)) {
                sqlParam.addValue("email", (Object)email);
            }
            this.executeSql(sqlBuffer.toString(), (SqlParameterSource)sqlParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TAccountInfo getPersonInfoByMail(String email) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT info.n_id id, info.c_user_name userName, info.c_email email, info.n_delete_flag deleteFlag, info.n_using_status usingStatus, info.n_headimg_time headImgTime, ").append(" info.n_status status, info.n_headimg headImg, di.n_acc_type accType, di.n_dev_type devType,info.c_audit_remark auditRemark FROM t_dev_account_info info ").append(" LEFT JOIN t_dev_info di ON info.n_id = di.n_dev_acc_id ").append("where info.c_email = :email ");
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        sqlParam.addValue("email", (Object)email);
        return (TAccountInfo)this.queryForObject(sqlBuffer.toString(), (SqlParameterSource)sqlParam, (RowMapper)new BeanRowMapper(TAccountInfo.class));
    }

    public void updateResetPwdTime(String email) {
        String sql = "UPDATE t_dev_account_info SET c_reset_time = 0000000000000 WHERE c_email = :email";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        sqlParam.addValue("email", (Object)email);
        this.executeSql(sql, (SqlParameterSource)sqlParam);
    }

    public int updateUnActiveEmail(String oldEmail, String newEmail) {
        String sql = "UPDATE t_dev_account_info SET c_email = :newEmail WHERE c_email = :oldEmail AND n_status =:status";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        sqlParam.addValue("newEmail", (Object)newEmail);
        sqlParam.addValue("oldEmail", (Object)oldEmail);
        sqlParam.addValue("status", (Object)1);
        return this.executeSql(sql, (SqlParameterSource)sqlParam);
    }

    public List<Map<String, Object>> getUserSummaryInfo(Long id) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT info.c_user_name userName, info.c_email email, dev.c_company_name companyName, dev.n_dev_type devType, dev.c_name devName, ").append("dev.c_org_name orgName,info.n_time registTime, info.n_activate_time activateTime, dev.n_time applyTime, ").append("info.n_audit_time auditTime, app.n_time authTime, ").append("app.c_name appName, app.c_package_name packageName, app.n_type platform ").append("FROM t_dev_account_info info LEFT JOIN t_dev_info dev ON info.n_id = dev.n_dev_acc_id ").append("LEFT JOIN t_app_info app ON info.n_id = app.n_dev_id   ").append("WHERE info.n_id = :id ORDER BY authTime DESC ");
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        sqlParam.addValue("id", (Object)id);
        return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)sqlParam);
    }
}

