/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.dao;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.cssp.open.system.entity.AppStatisticsInfoBean;
import com.xdja.cssp.open.system.entity.AuthServerBean;
import com.xdja.cssp.open.system.entity.OpenApp;
import com.xdja.cssp.open.system.entity.TAppInfo;
import com.xdja.cssp.open.system.entity.TAppInfoBean;
import com.xdja.cssp.open.system.entity.TAppInfoCondition;
import com.xdja.cssp.open.system.entity.TAppInfoExtendBean;
import com.xdja.cssp.open.system.util.DateQueryBean;
import com.xdja.platform.datacenter.jpa.dao.BaseJdbcDao;
import com.xdja.platform.datacenter.jpa.dao.helper.BeanRowMapper;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JsonMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TAppInfoDao
extends BaseJdbcDao {
    public List<TAppInfo> ajaxAppInfoList(TAppInfoExtendBean appInfoExtendBean, Long pageNum, int pageSize, DateQueryBean queryBean) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT").append(" appInfo.c_app_id AS appId,").append(" appInfo.c_name AS appName,").append(" appInfo.n_status AS authorizeStatus,").append(" appInfo.c_copyright AS copyRight,").append(" devInfo.c_surname AS surName,").append(" devInfo.c_name AS name, ").append(" appInfo.n_time AS time, ").append(" devInfo.c_company_name companyName ").append(" FROM").append(" t_app_info appInfo");
        sqlBuilder.append(" LEFT JOIN t_dev_info devInfo ON appInfo.n_dev_id = devInfo.n_dev_acc_id ").append(" WHERE 1=1");
        if (null != appInfoExtendBean) {
            if (StringUtils.isNotBlank((CharSequence)appInfoExtendBean.getKeyWord())) {
                String keyWord = appInfoExtendBean.getKeyWord().replaceAll("%", "/%").replaceAll("_", "/_");
                sqlBuilder.append(" AND appInfo.c_name LIKE :keyWord ESCAPE '/'").append(" OR devInfo.c_surname LIKE :keyWord ESCAPE '/'").append(" OR devInfo.c_name LIKE :keyWord ESCAPE '/'").append(" OR devInfo.c_company_name LIKE :keyWord ESCAPE '/'");
                sqlParam.addValue("keyWord", (Object)("%" + keyWord + "%"));
            }
            if (appInfoExtendBean.getPlatform() > 0) {
                sqlBuilder.append(" AND appInfo.n_type = :platform");
                sqlParam.addValue("platform", (Object)appInfoExtendBean.getPlatform());
            }
            if (appInfoExtendBean.getStatus() > 0) {
                sqlBuilder.append(" AND appInfo.n_status = :status ");
                sqlParam.addValue("status", (Object)appInfoExtendBean.getStatus());
            }
        }
        if (null != queryBean.getTimeStart()) {
            sqlBuilder.append(" AND appInfo.n_time >= :startTime");
            sqlParam.addValue("startTime", (Object)queryBean.getTimeStart());
        }
        if (null != queryBean.getTimeEnd()) {
            sqlBuilder.append(" AND appInfo.n_time <= :endTime");
            sqlParam.addValue("endTime", (Object)queryBean.getTimeEnd());
        }
        sqlBuilder.append(" ORDER BY appInfo.n_time DESC");
        Long start = (pageNum - 1L) * (long)pageSize;
        sqlBuilder.append(" LIMIT " + start + "," + pageSize);
        return this.queryForList(sqlBuilder.toString(), (SqlParameterSource)sqlParam, (RowMapper)new BeanPropertyRowMapper(TAppInfo.class));
    }

    public Long queryCountInfo(TAppInfoExtendBean appInfoExtendBean, Long pageNum, int pageSize, DateQueryBean queryBean) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT COUNT(*)").append(" FROM").append(" t_app_info appInfo").append(" LEFT JOIN t_dev_info devInfo ON appInfo.n_dev_id = devInfo.n_dev_acc_id").append(" WHERE 1=1");
        if (null != appInfoExtendBean) {
            if (StringUtils.isNotBlank((CharSequence)appInfoExtendBean.getKeyWord())) {
                String keyWord = appInfoExtendBean.getKeyWord().replaceAll("%", "/%").replaceAll("_", "/_");
                sqlBuilder.append(" AND appInfo.c_name LIKE :keyWord ESCAPE '/'").append(" OR devInfo.c_surname LIKE :keyWord ESCAPE '/'").append(" OR devInfo.c_name LIKE :keyWord ESCAPE '/'").append(" OR devInfo.c_company_name LIKE :keyWord ESCAPE '/'");
                sqlParam.addValue("keyWord", (Object)("%" + keyWord + "%"));
            }
            if (appInfoExtendBean.getPlatform() > 0) {
                sqlBuilder.append(" AND appInfo.n_type = :platform");
                sqlParam.addValue("platform", (Object)appInfoExtendBean.getPlatform());
            }
            if (appInfoExtendBean.getStatus() > 0) {
                sqlBuilder.append(" AND appInfo.n_status = :status ");
                sqlParam.addValue("status", (Object)appInfoExtendBean.getStatus());
            }
        }
        if (null != queryBean.getTimeStart()) {
            sqlBuilder.append(" AND appInfo.n_time >= :startTime");
            sqlParam.addValue("startTime", (Object)queryBean.getTimeStart());
        }
        if (null != queryBean.getTimeEnd()) {
            sqlBuilder.append(" AND appInfo.n_time <= :endTime");
            sqlParam.addValue("endTime", (Object)queryBean.getTimeEnd());
        }
        sqlBuilder.append(" ORDER BY appInfo.n_time DESC");
        return this.queryForLong(sqlBuilder.toString(), (SqlParameterSource)sqlParam);
    }

    public TAppInfo queryAppDetail(String appId) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT").append(" appInfo.c_app_id AS appId,").append(" appInfo.c_name AS appName,").append(" appInfo.c_package_name AS packageName,").append(" appInfo.c_package_size AS packageSize,").append(" appInfo.n_status AS authorizeStatus,").append(" appInfo.n_type AS type,").append(" appInfo.c_copyright AS copyRight,").append(" appInfo.c_app_note AS appNote,").append(" devInfo.c_surname AS surName,").append(" devInfo.c_name AS name,").append(" devInfo.c_mobile AS mobile,").append(" devInfo.n_country AS country,").append(" devInfo.n_city AS city,").append(" accountInfo.c_email AS email, ").append(" devInfo.c_company_name companyName").append(" FROM t_app_info appInfo");
        sqlBuilder.append(" LEFT JOIN t_dev_info devInfo ON appInfo.n_dev_id = devInfo.n_dev_acc_id").append(" LEFT JOIN t_dev_account_info accountInfo ON accountInfo.n_id = devInfo.n_dev_acc_id").append(" WHERE 1=1");
        sqlBuilder.append(" AND appInfo.c_app_id = :appId");
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sqlParam.addValue("appId", (Object)appId);
        }
        return (TAppInfo)this.queryForObject(sqlBuilder.toString(), (SqlParameterSource)sqlParam, (RowMapper)new BeanRowMapper(TAppInfo.class));
    }

    public TAppInfo getAppNote(String appId) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT").append(" appInfo.c_app_id AS appId,").append(" appInfo.c_name appName, ").append(" appInfo.c_cert_hashval certHashval, ").append(" appInfo.c_package_name AS packageName,").append(" appInfo.c_app_note AS appNote,").append(" appInfo.c_auth_path AS authPath,").append(" appInfo.c_auth_hashval AS authHashval, ").append(" appInfo.n_status AS authorizeStatus, ").append(" appInfo.c_auth_name AS authFileName ").append(" FROM t_app_info appInfo");
        sqlBuilder.append(" WHERE 1=1").append(" AND appInfo.c_app_id = :appId");
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sqlParam.addValue("appId", (Object)appId);
        }
        return (TAppInfo)this.queryForObject(sqlBuilder.toString(), (SqlParameterSource)sqlParam, (RowMapper)new BeanRowMapper(TAppInfo.class));
    }

    public void updateAuthorizeStatus(String appId, Integer status) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer("UPDATE");
        sqlBuffer.append(" t_app_info appInfo SET").append(" appInfo.n_status = :status").append(" WHERE 1=1").append(" AND appInfo.c_app_id = :appId");
        if (null != status && status > 0) {
            sqlParam.addValue("status", (Object)status);
        }
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            sqlParam.addValue("appId", (Object)appId);
        }
        this.addOrUpdate(sqlBuffer.toString(), new SqlParameterSource[]{sqlParam});
    }

    public void submitAppAuthorize(TAppInfo appInfo) {
        MapSqlParameterSource appSqlParam = new MapSqlParameterSource();
        MapSqlParameterSource sdkSqlParam = new MapSqlParameterSource();
        StringBuilder appSql = new StringBuilder("INSERT INTO t_app_info").append("(").append("c_app_id, c_name, c_package_name, c_cert_hashval,").append("c_auth_path, c_auth_hashval, c_secretkey,").append("c_token, n_time, n_type, n_dev_id, n_suit_style").append(")").append(" VALUES(").append(" :appId, :appName, :packageName, :certHashval,").append(" :authPath, :authHashval, :secretKey,").append(" :token, :time, :type, :devId, :suitStyle").append(")");
        if (StringUtils.isNotBlank((CharSequence)appInfo.getAppId())) {
            appSqlParam.addValue("appId", (Object)appInfo.getAppId());
        }
        if (StringUtils.isNotBlank((CharSequence)appInfo.getAppName())) {
            appSqlParam.addValue("appName", (Object)appInfo.getAppName());
        }
        if (StringUtils.isNotBlank((CharSequence)appInfo.getPackageName())) {
            appSqlParam.addValue("packageName", (Object)appInfo.getPackageName());
        }
        if (StringUtils.isNotBlank((CharSequence)appInfo.getCertHashval())) {
            appSqlParam.addValue("certHashval", (Object)appInfo.getCertHashval().toUpperCase());
        }
        if (StringUtils.isNotBlank((CharSequence)appInfo.getAuthPath())) {
            appSqlParam.addValue("authPath", (Object)appInfo.getAuthPath());
        }
        if (StringUtils.isNotBlank((CharSequence)appInfo.getAuthHashval())) {
            appSqlParam.addValue("authHashval", (Object)appInfo.getAuthHashval());
        }
        if (StringUtils.isNotBlank((CharSequence)appInfo.getSecretKey())) {
            appSqlParam.addValue("secretKey", (Object)appInfo.getSecretKey());
        }
        if (StringUtils.isNotBlank((CharSequence)appInfo.getToken())) {
            appSqlParam.addValue("token", (Object)appInfo.getToken());
        }
        if (null != appInfo.getTime() && appInfo.getTime() > 0L) {
            appSqlParam.addValue("time", (Object)appInfo.getTime());
        }
        if (null != appInfo.getType() && appInfo.getType() > 0) {
            appSqlParam.addValue("type", (Object)appInfo.getType());
        }
        if (null != appInfo.getDevId() && appInfo.getDevId() > 0L) {
            appSqlParam.addValue("devId", (Object)appInfo.getDevId());
        }
        if (StringUtils.isNotBlank((CharSequence)appInfo.getSuitStyle())) {
            appSqlParam.addValue("suitStyle", (Object)appInfo.getSuitStyle());
        }
        try {
            this.addOrUpdate(appSql.toString(), new SqlParameterSource[]{appSqlParam});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isNotBlank((CharSequence)appInfo.getAppId())) {
            String[] sdkIds = appInfo.getSdkIds();
            for (int i = 0; i < sdkIds.length; ++i) {
                StringBuilder sdkSql = new StringBuilder();
                sdkSql.append("INSERT INTO t_app_sdk(c_sdk_id,c_app_id)values(").append(":sdkId,:appId)");
                sdkSqlParam.addValue("sdkId", (Object)sdkIds[i]);
                sdkSqlParam.addValue("appId", (Object)appInfo.getAppId());
                try {
                    this.addOrUpdate(sdkSql.toString(), new SqlParameterSource[]{sdkSqlParam});
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (appInfo instanceof TAppInfoBean) {
                TAppInfoBean tAppInfoBean = (TAppInfoBean)appInfo;
                long time = System.currentTimeMillis();
                StringBuilder sdkAuthInfoSql = new StringBuilder();
                sdkAuthInfoSql.append("INSERT INTO t_app_sdk_auth_info(c_sdk_id, c_app_id, c_auth_server, c_token, n_suit_style, n_time)values(").append(":sdkId, :appId, :authServer, :token, :suitStyle, :time)");
                for (AuthServerBean authServerBean : tAppInfoBean.getAuthServerBeanList()) {
                    MapSqlParameterSource sdkAuthSqlParam;
                    if (authServerBean.getCkms() != null) {
                        sdkAuthSqlParam = this.buildSdkAuthSqlParam(authServerBean, time, "CKMS");
                        try {
                            this.addOrUpdate(sdkAuthInfoSql.toString(), new SqlParameterSource[]{sdkAuthSqlParam});
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (authServerBean.getKdc() == null) continue;
                    sdkAuthSqlParam = this.buildSdkAuthSqlParam(authServerBean, time, "KDC");
                    try {
                        this.addOrUpdate(sdkAuthInfoSql.toString(), new SqlParameterSource[]{sdkAuthSqlParam});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private MapSqlParameterSource buildSdkAuthSqlParam(AuthServerBean authServerBean, long time, String authServer) {
        MapSqlParameterSource sdkAuthSqlParam = new MapSqlParameterSource();
        sdkAuthSqlParam.addValue("sdkId", (Object)authServerBean.getSdkId());
        sdkAuthSqlParam.addValue("appId", (Object)authServerBean.getAppId());
        sdkAuthSqlParam.addValue("authServer", (Object)authServer);
        sdkAuthSqlParam.addValue("token", (Object)authServerBean.getToken());
        if ("CKMS".equalsIgnoreCase(authServer)) {
            sdkAuthSqlParam.addValue("suitStyle", (Object)authServerBean.getCkms());
        } else if ("KDC".equalsIgnoreCase(authServer)) {
            sdkAuthSqlParam.addValue("suitStyle", (Object)authServerBean.getKdc());
        }
        sdkAuthSqlParam.addValue("time", (Object)time);
        return sdkAuthSqlParam;
    }

    public Map<String, OpenApp> queryAuthInfoByAppId(String ... appId) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT c_app_id appId, c_name name, c_secretkey secretKey, ").append("c_package_name pkgName, n_suit_style suit, n_type type, n_time time ").append("FROM t_app_info ").append("WHERE c_app_id = :appId AND n_status =:status ");
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        sqlParam.addValue("appId", (Object)appId);
        sqlParam.addValue("status", (Object)TAppInfo.ENUM_APP_STATUS.authorized.value);
        return null;
    }

    public boolean checkAppNameExist(String appName) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT count(n_id) ").append("FROM t_app_info ").append("WHERE c_name = :appName AND n_status = :status ");
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            sqlParam.addValue("appName", (Object)appName);
        }
        sqlParam.addValue("status", (Object)TAppInfo.ENUM_APP_STATUS.authorized.value);
        int resultLong = this.queryForInt(sqlBuffer.toString(), (SqlParameterSource)sqlParam);
        return resultLong > 0;
    }

    public boolean checkPackageNameExist(String packageName) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT count(*) ").append("FROM t_app_info ").append("WHERE c_package_name = :packageName AND n_status =:status ");
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        if (StringUtils.isNotBlank((CharSequence)packageName)) {
            sqlParam.addValue("packageName", (Object)packageName);
        }
        sqlParam.addValue("status", (Object)TAppInfo.ENUM_APP_STATUS.authorized.value);
        int resultLong = this.queryForInt(sqlBuffer.toString(), (SqlParameterSource)sqlParam);
        return resultLong > 0;
    }

    public List<TAppInfoCondition> getAppInfosByUserId(Long userId) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT DISTINCT info.c_app_id appId, info.c_name appName, info.c_package_name packageName, info.n_time time, info.n_status authorizeStatus, ").append("info.n_type platform, appSdk.n_app_flag appFlag FROM t_app_info info LEFT JOIN t_app_sdk appSdk ON info.c_app_id = appSdk.c_app_id ").append("WHERE info.n_dev_id = :userId ");
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        sqlParam.addValue("userId", (Object)userId);
        sqlBuffer.append("ORDER BY info.n_time DESC ");
        return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)sqlParam, (RowMapper)BeanPropertyRowMapper.newInstance(TAppInfoCondition.class));
    }

    public Map<String, OpenApp> queryAuthAppInfos(String[] appIds) {
        String appIdParams = "";
        for (String appId : appIds) {
            appIdParams = appIdParams + "\"" + appId + "\",";
        }
        final HashMap<String, OpenApp> result = new HashMap<String, OpenApp>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT appInfo.c_app_id appId, appInfo.c_name name, appInfo.c_secretkey secretKey, ").append("appInfo.c_package_name pkgName, appInfo.n_suit_style suit, appInfo.n_type type, appInfo.n_time time, ").append("appInfo.c_copyright copyright, appInfo.c_internal_version interVersion, ").append("appInfo.c_version version, appInfo.c_package_hashval pkgHashVal, appInfo.c_cert_hashval pkgSign, ").append("appInfo.c_token token, authInfo.c_token newToken ").append("FROM t_app_info appInfo LEFT JOIN t_app_sdk_auth_info authInfo ON appInfo.c_app_id = authInfo.c_app_id ").append("WHERE appInfo.n_status = :status AND appInfo.c_app_id IN (" + appIdParams.substring(0, appIdParams.length() - 1) + ") ");
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        sqlParam.addValue("status", (Object)TAppInfo.ENUM_APP_STATUS.authorized.value);
        System.out.println("sql:" + sqlBuffer.toString());
        System.out.println("appIdParams:" + appIdParams);
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)sqlParam, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                OpenApp appInfo = new OpenApp();
                System.out.println(result.size());
                System.out.println(rs.getString("appId"));
                System.out.println(result.get(rs.getString("appId")));
                if (null == result.get(rs.getString("appId"))) {
                    appInfo.setAppId(rs.getString("appId"));
                    if (null == rs.getString("newToken")) {
                        appInfo.setPkgSign(rs.getString("pkgSign") == null ? "" : rs.getString("pkgSign"));
                        appInfo.setCopyright(rs.getString("copyright") == null ? "" : rs.getString("copyright"));
                        appInfo.setInterVersion(rs.getString("interVersion") == null ? "" : rs.getString("interVersion"));
                        appInfo.setName(rs.getString("name") == null ? "" : rs.getString("name"));
                        appInfo.setPkgHashVal(rs.getString("pkgHashVal") == null ? "" : rs.getString("pkgHashVal"));
                        appInfo.setPkgName(rs.getString("pkgName") == null ? "" : rs.getString("pkgName"));
                        appInfo.setSecretKey(rs.getString("secretKey"));
                        appInfo.setSuit(rs.getInt("suit"));
                        appInfo.setTime(rs.getLong("time"));
                        appInfo.setToken(rs.getString("token") == null ? "" : rs.getString("token"));
                        appInfo.setVersion(rs.getString("version") == null ? "" : rs.getString("version"));
                        appInfo.setType(rs.getInt("type"));
                    } else {
                        appInfo.setPkgSign(rs.getString("pkgSign") == null ? "" : rs.getString("pkgSign"));
                        appInfo.setCopyright(rs.getString("copyright") == null ? "" : rs.getString("copyright"));
                        appInfo.setInterVersion(rs.getString("interVersion") == null ? "" : rs.getString("interVersion"));
                        appInfo.setName(rs.getString("name") == null ? "" : rs.getString("name"));
                        appInfo.setPkgHashVal(rs.getString("pkgHashVal") == null ? "" : rs.getString("pkgHashVal"));
                        appInfo.setPkgName(rs.getString("pkgName") == null ? "" : rs.getString("pkgName"));
                        appInfo.setSecretKey(rs.getString("secretKey"));
                        appInfo.setTime(rs.getLong("time"));
                        appInfo.setToken(rs.getString("newToken") == null ? "" : rs.getString("newToken"));
                        appInfo.setVersion(rs.getString("version") == null ? "" : rs.getString("version"));
                        appInfo.setType(rs.getInt("type"));
                        String newToken = rs.getString("newToken");
                        try {
                            Map map = (Map)JsonMapper.alwaysMapper().fromJson(newToken, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                            if (null != map) {
                                Object kdcObject;
                                Object ckmsObject = map.get("token_data");
                                if (null != ckmsObject) {
                                    Map ckmsMap = (Map)map.get("token_data");
                                    String signature = map.get("signature").toString();
                                    Integer suit = Integer.valueOf(ckmsMap.get("suit").toString());
                                    appInfo.setSuit(suit.intValue());
                                }
                                if (null != (kdcObject = map.get("kdc_data"))) {
                                    Map kdcMap = (Map)map.get("kdc_data");
                                    Long kdcSuit = Long.valueOf(kdcMap.get("suit").toString());
                                    appInfo.setKdcSuit(kdcSuit);
                                    Integer kdcAuthType = Integer.valueOf(kdcMap.get("authType").toString());
                                    appInfo.setKdcAuthType(kdcAuthType.intValue());
                                    String kdcVersion = kdcMap.get("version").toString();
                                    appInfo.setKdcVersion(kdcVersion);
                                    String kdcSignature = map.get("signature_kdc").toString();
                                    appInfo.setKdcSignature(kdcSignature);
                                }
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    result.put(appInfo.getAppId(), appInfo);
                }
                return null;
            }
        });
        return result;
    }

    public List<AppStatisticsInfoBean> getAppStatisticInfo() {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT distinct c_app_id As appIdentifier, c_name As appName, n_type As appType FROM t_app_info");
        return this.queryForList(sqlBuffer.toString(), null, (RowMapper)BeanPropertyRowMapper.newInstance(AppStatisticsInfoBean.class));
    }

    public static void main(String[] args) {
        String dd = "{\"token_data\":{\"suit\":2561,\"packageName\":\"xdja.com.testkdcsdk\",\"appId\":\"b38ba9b7062940dda1b04e1491325fc6\"},\"signature_alg\":\"sm2WithSm3\"}";
        try {
            Map map = (Map)JsonMapper.alwaysMapper().fromJson(dd, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            if (null != map) {
                Object kdcObject;
                Object ckmsObject = map.get("token_data");
                if (null != ckmsObject) {
                    Map ckmsMap = (Map)map.get("token_data");
                    String signature = map.get("signature").toString();
                    Integer suit = Integer.valueOf(ckmsMap.get("suit").toString());
                    System.out.println(ckmsMap);
                }
                if (null != (kdcObject = map.get("kdc_data"))) {
                    Map kdcMap = (Map)map.get("kdc_data");
                    Integer kdcSuit = Integer.valueOf(kdcMap.get("suit").toString());
                    Integer kdcAuthType = Integer.valueOf(kdcMap.get("authType").toString());
                    String kdcVersion = kdcMap.get("version").toString();
                    String kdcSignature = map.get("signature_kdc").toString();
                    System.out.println(kdcMap);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

