/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.dao;

import com.xdja.cssp.open.system.entity.TUser;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TUserDao
extends BaseJpaDao<TUser, Long> {
    public TUser getUserByCardId(String cardId) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder("SELECT * ");
        sql.append(" FROM t_sys_user user");
        sql.append(" LEFT JOIN t_sys_user_cert cert ON user.n_id = cert.n_user_id");
        sql.append(" WHERE cert.c_card_id = :cardId");
        sqlParam.addValue("cardId", (Object)cardId);
        String strSql = sql.toString();
        this.queryForObject(strSql, (SqlParameterSource)sqlParam, (RowMapper)new BeanPropertyRowMapper());
        return (TUser)this.queryForObject(strSql, (SqlParameterSource)sqlParam, (RowMapper)new BeanPropertyRowMapper());
    }

    public String getUserNameByCardId(String cardId) {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder("SELECT c_user_name ");
        sql.append(" FROM t_sys_user user");
        sql.append(" LEFT JOIN t_sys_user_cert cert ON user.n_id = cert.n_user_id");
        sql.append(" WHERE 1=1").append(" AND cert.c_card_id = :cardId");
        if (StringUtils.isNotBlank((CharSequence)cardId)) {
            sqlParam.addValue("cardId", (Object)cardId);
        }
        String strSql = sql.toString();
        Map map = null;
        try {
            map = this.queryForMap(strSql, (SqlParameterSource)sqlParam);
            return map.get("c_user_name").toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer isSysInit() {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        String sql = "SELECT COUNT(n_id) FROM t_sys_user WHERE n_type = :type";
        sqlParam.addValue("type", (Object)TUser.ENUM_USER_TYPE.systemUser.value);
        return this.queryForInt(sql, (SqlParameterSource)sqlParam);
    }

    public int queryCardIsBind(String uName, String cardId) {
        StringBuilder sql = new StringBuilder("SELECT count(0) ");
        sql.append(" FROM t_sys_user_cert cert");
        sql.append(" LEFT JOIN t_sys_user user ON cert.n_user_id = user.n_id");
        sql.append(" WHERE user.c_user_name = :userName AND cert.c_card_id = :cardId");
        MapSqlParameterSource paramSource = new MapSqlParameterSource();
        paramSource.addValue("cardId", (Object)cardId);
        paramSource.addValue("userName", (Object)uName);
        return this.queryForInt(sql.toString(), (SqlParameterSource)paramSource);
    }

    public Pagination<TUser> queryAllUsers(TUser user, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT n_id AS id, c_user_name AS userName, ").append("c_name AS name, c_mobile AS mobile, n_status AS status, n_time AS createTime FROM t_sys_user WHERE 1=1 ");
        if (null != user) {
            if (StringUtils.isNotBlank((CharSequence)user.getName())) {
                String name = user.getName();
                sqlBuilder.append("AND c_name like :name ESCAPE '/' ");
                name = name.replaceAll("%", "/%");
                name = name.replaceAll("_", "/_");
                sqlParameterSource.addValue("name", (Object)("%" + name + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)user.getUserName())) {
                String userName = user.getUserName();
                sqlBuilder.append("AND c_user_name like :userName ESCAPE '/' ");
                userName = userName.replaceAll("%", "/%");
                userName = userName.replaceAll("_", "/_");
                sqlParameterSource.addValue("userName", (Object)("%" + userName + "%"));
            }
        }
        sqlBuilder.append("AND n_delete_flag = :deleteFlag ");
        sqlParameterSource.addValue("deleteFlag", (Object)TUser.ENUM_DELETE_FLAG.normalFlag.value);
        sqlBuilder.append("AND n_type = :type ");
        sqlParameterSource.addValue("type", (Object)TUser.ENUM_USER_TYPE.consumerUser.value);
        if (StringUtils.isNotEmpty((CharSequence)sortName) && StringUtils.isNotEmpty((CharSequence)sortType)) {
            sqlBuilder.append("ORDER BY " + sortName + " " + sortType);
        } else {
            sqlBuilder.append("ORDER BY n_time DESC ");
        }
        return this.queryForPage(sqlBuilder.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(TUser.class));
    }

    public Long queryUsersCount() {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT COUNT(n_id) FROM t_sys_user WHERE ");
        sqlBuffer.append(" n_delete_flag = :deleteFlag ").append("AND n_type = :type ");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("deleteFlag", (Object)TUser.ENUM_DELETE_FLAG.normalFlag.value);
        sqlParameterSource.addValue("type", (Object)TUser.ENUM_USER_TYPE.consumerUser.value);
        return this.queryForLong(sqlBuffer.toString(), (SqlParameterSource)sqlParameterSource);
    }

    public List<TUser> queryAllUsersList(Long pageNo, Integer pageSize) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT user.n_id id, user.c_user_name userName, user.c_name name, user.c_mobile mobile, user.c_email email, ").append("user.n_time createTime, cert.c_card_id cardId ").append("FROM t_sys_user user LEFT JOIN t_sys_user_cert cert ON user.n_id = cert.n_user_id ").append("WHERE n_delete_flag = :deleteFlag AND n_type = :type ");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("deleteFlag", (Object)TUser.ENUM_DELETE_FLAG.normalFlag.value);
        sqlParameterSource.addValue("type", (Object)TUser.ENUM_USER_TYPE.consumerUser.value);
        return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(TUser.class));
    }
}

