/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.system.service.impl;

import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.system.business.IRoleBusiness;
import com.xdja.cssp.open.system.entity.Function;
import com.xdja.cssp.open.system.entity.TRole;
import com.xdja.cssp.open.system.entity.TRoleFunction;
import com.xdja.cssp.open.system.entity.TUserRole;
import com.xdja.cssp.open.system.service.IRoleService;
import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class RoleServiceImpl
implements IRoleService {
    @Resource
    private IRoleBusiness roleBusiness;

    public void saveRole(TRole role, String funcIds) {
        if (null != role) {
            if (!StringUtils.isNotBlank((CharSequence)funcIds)) {
                throw new IllegalArgumentException("\u4e3a\u89d2\u8272\u7ed1\u5b9a\u7684\u529f\u80fd\u6743\u9650\u4e3a\u7a7a");
            }
        } else {
            throw new IllegalArgumentException("\u89d2\u8272\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.roleBusiness.saveRole(role, funcIds);
    }

    public LitePaging<TRole> queryAllRoles(TRole roleCondition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        return PagingConverter.convert(this.roleBusiness.queryAllRoles(roleCondition, pageNo, pageSize, sortName, sortType));
    }

    public List<Map<String, Object>> queryAllFunctions(String roleId) {
        List<TRoleFunction> roleFunctionList;
        ArrayList<Long> roleFuncIds = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)roleId) && !(roleFunctionList = this.roleBusiness.queryRoleFunctionByRoleId(Long.valueOf(roleId))).isEmpty()) {
            for (TRoleFunction roleFunction : roleFunctionList) {
                roleFuncIds.add(roleFunction.getFunctionId());
            }
        }
        List<Function> listFunction = this.roleBusiness.queryAllFunctions();
        HashMap<Long, Map> resultMap = new HashMap<Long, Map>();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Function function : listFunction) {
            List childMapList;
            Map tempMap;
            HashMap<String, Object> funcMap = new HashMap<String, Object>();
            funcMap.put("id", function.getId());
            funcMap.put("pId", function.getParentId());
            funcMap.put("name", function.getName());
            funcMap.put("checked", roleFuncIds.contains(function.getId()));
            if (0L == function.getParentId()) {
                tempMap = (Map)resultMap.get(function.getId());
                if (null != tempMap && null != (childMapList = (LinkedList)tempMap.get("children"))) {
                    funcMap.put("children", childMapList);
                }
                resultMap.put(function.getId(), funcMap);
                continue;
            }
            tempMap = (Map)resultMap.get(function.getParentId());
            if (null == tempMap) {
                resultMap.put(function.getParentId(), funcMap);
                continue;
            }
            childMapList = (List)tempMap.get("children");
            if (null == childMapList) {
                childMapList = new LinkedList();
            }
            childMapList.add(funcMap);
            tempMap.put("children", childMapList);
            resultMap.put(function.getParentId(), tempMap);
        }
        for (Map.Entry entry : resultMap.entrySet()) {
            result.add((Map)entry.getValue());
        }
        return result;
    }

    public TRole getRoleById(Long roleId) {
        TRole role = null;
        List<Map<String, Object>> functionList = null;
        if (null == roleId) {
            role = new TRole();
            functionList = this.queryAllFunctions("");
        } else {
            role = this.roleBusiness.getRoleById(roleId);
            functionList = this.queryAllFunctions(String.valueOf(roleId));
        }
        role.setFunctionList(functionList);
        return role;
    }

    public List<TRole> queryListRoles() {
        return this.roleBusiness.queryListRoles();
    }

    public List<TRole> queryListRolesOrCheck(Long userId) {
        List<TRole> roleList;
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        ArrayList<TRole> roleReturnList = new ArrayList<TRole>();
        List<Object> userRoleList = new ArrayList();
        if (null != userId && !(userRoleList = this.roleBusiness.queryUserRoleListByUserId(userId)).isEmpty()) {
            for (TUserRole tUserRole : userRoleList) {
                roleIdList.add(tUserRole.getRoleId());
            }
        }
        if (!(roleList = this.roleBusiness.queryListRoles()).isEmpty()) {
            for (TRole role : roleList) {
                if (roleIdList.contains(role.getId())) {
                    role.setCheckFlag(true);
                }
                roleReturnList.add(role);
            }
        }
        return roleReturnList;
    }

    public Boolean isRoleNameExist(Long roleId, String roleName) {
        return this.roleBusiness.isRoleNameExist(roleId, roleName);
    }

    public ReturnCodeUtil queryAllRolesList(Long pageNo, Integer pageSize) {
        return this.roleBusiness.queryAllRolesList(pageNo, pageSize);
    }

    public void deleteRoleById(Long id) {
        this.roleBusiness.deleteRoleById(id);
    }
}

