/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.pmc.service;

import com.xdja.cssp.open.core.util.SmsUtil;
import com.xdja.cssp.open.utils.Constants;
import com.xdja.cssp.open.utils.MailUtil;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.microservice.config.MicroServiceConfig;
import com.xdja.platform.microservice.plugin.IPlugin;
import com.xdja.platform.microservice.plugin.Plugins;
import com.xdja.platform.microservice.spring.SpringPlugin;
import com.xdja.platform.remoting.serialize.Serialization;
import com.xdja.platform.rpc.consumer.IService;
import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.consumer.ServicePool;
import com.xdja.platform.rpc.provider.ProviderStarter;
import java.net.BindException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMCConfig
extends MicroServiceConfig {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String IP = "127.0.0.1";
    private static final int PORT = 6666;
    private static final int MAXWORKTHREAD = 100;

    public void configPlugin(Plugins me) {
        try {
            String[] configLocations = new String[]{"classpath*:/META-INF/spring/applicationContext-*.xml", "classpath*:/applicationContext.xml"};
            me.add((IPlugin)new SpringPlugin(configLocations));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void afterStart() {
        Prop prop = PropKit.use((String)"system.properties");
        Prop configProp = PropKit.use((String)"config.properties");
        String ip = prop.get("rpc.ip", IP);
        int port = prop.getInt("rpc.port", Integer.valueOf(6666));
        int maxWorkThread = prop.getInt("rpc.maxWorkThread", Integer.valueOf(100));
        try {
            String[] rpcServices;
            Service rpcService = null;
            for (String service : rpcServices = StringUtils.split((String)prop.get("rpc.services"), (String)"|")) {
                rpcService = new Service();
                rpcService.setAddr(prop.get("rpc." + service + ".ip"));
                rpcService.setPort(Integer.parseInt(prop.get("rpc." + service + ".port")));
                if (prop.containsKey("rpc." + service + ".serialization")) {
                    rpcService.setSerialization(Serialization.valueOf((String)prop.get("rpc." + service + ".serialization")));
                }
                if (prop.containsKey("rpc." + service + ".timeoutMillis")) {
                    rpcService.setTimeoutMillis(Long.valueOf(prop.get("rpc." + service + ".timeoutMillis")).longValue());
                }
                ServicePool.addService((String)service, (IService)rpcService);
                this.logger.debug("\u6ce8\u518c\u666e\u901arpc service\uff08{}==>{}:{}\uff09\u6210\u529f", new Object[]{service, rpcService.getAddr(), rpcService.getPort()});
            }
            ProviderStarter.NETTY.setMaxWorkThread(maxWorkThread).start(ip, port);
            this.logger.debug("====>PMC\u670d\u52a1{}:{}\u542f\u52a8\u6210\u529f\uff0c\u6700\u5927\u5de5\u4f5c\u7ebf\u7a0b\u6570\u4e3a{}\u4e2a\uff01", new Object[]{ip, port, maxWorkThread});
        }
        catch (BindException e) {
            this.logger.error("\u670d\u52a1\u7ed1\u5b9a\u5f02\u5e38", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.logger.error("\u7ebf\u7a0b\u5f02\u5e38", (Throwable)e);
        }
        Constants.IP_REGIST_LIMIT = prop.getInt("ip.regist.limit", Integer.valueOf(10));
        Constants.PASSWD_ERROR_LIMIT = prop.getInt("passwd.error.limit", Integer.valueOf(3));
        Constants.PHONE_CODE_LIMIT = prop.getInt("phone.code.limit", Integer.valueOf(5));
        Constants.PHONE_CODE_ERROR = prop.getInt("phone.code.error", Integer.valueOf(3));
        Constants.FILE_SERVER_IP = prop.get("file.server.ip");
        Constants.FILE_SERVER_USERID = prop.get("file.server.userid");
        Constants.FILE_SERVER_USERSECRET = prop.get("file.server.usersecret");
        Constants.FILE_UPLOAD_TIMEOUT = prop.getLong("file.upload.timeout");
        Constants.FILE_DOWNLOAD_TIMEOUT = prop.getLong("file.download.timeout");
        Constants.FILE_HTTP_PORT = prop.get("file.http.port");
        Constants.FILE_HTTPS_PORT = prop.get("file.https.port");
        this.initSMS(prop);
        this.initMail(prop);
        this.initConfigPath(configProp);
    }

    public void initSMS(Prop prop) {
        try {
            String host = prop.get("sms.host");
            String port = prop.get("sms.port");
            boolean useProxy = prop.getBoolean("sms.use.proxy");
            String proxyHost = prop.get("sms.proxy.host");
            int proxyPort = prop.getInt("sms.proxy.port");
            String sId = prop.get("sms.sid");
            String token = prop.get("sms.token");
            String appId = prop.get("sms.appid");
            SmsUtil.init((String)host, (String)port, (boolean)useProxy, (String)proxyHost, (int)proxyPort, (String)sId, (String)token, (String)appId);
            Constants.PHONE_IDENTIFY_ID = prop.get("sms.template.id");
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38");
        }
    }

    public void initMail(Prop prop) {
        try {
            String proxyHost = prop.get("mail.host");
            int port = prop.getInt("mail.port");
            String protocol = prop.get("mail.protocol");
            String username = prop.get("mail.username");
            String password = prop.get("mail.password");
            Constants.FROM_MAIL_ADDRESS = prop.get("mail.fromMail");
            Constants.OPEN_HTML_URL = prop.get("open.html.url");
            MailUtil.init((String)proxyHost, (int)port, (String)protocol, (String)username, (String)password);
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u90ae\u4ef6\u53d1\u9001\u670d\u52a1\u5f02\u5e38");
        }
    }

    public void initConfigPath(Prop configProp) {
        try {
            Constants.EMAIL_SKIP_PATH = configProp.get("email.route.path");
            Constants.EMIAL_SERVICE_ADDRESS = configProp.get("emial.service.address");
            Constants.EMAIL_SKIP_SUBJECT = configProp.get("email_skip_subject");
            Constants.EMAIL_ACTIVE_UPSIDE = configProp.get("email.active.upside");
            Constants.EMAIL_ACTIVE_DOWNSIDE = configProp.get("email.active.downside");
            Constants.EMAIL_RESET_SUBJECT = configProp.get("email.reset.subject");
            Constants.EMAIL_RESET_CONTENT1 = configProp.get("email.reset.content1");
            Constants.EMAIL_RESET_CONTENT2 = configProp.get("email.reset.content2");
            Constants.EMAIL_RESET_CONTENT3 = configProp.get("email.reset.content3");
            Constants.COMMON_MAIL_CONTENT1 = configProp.get("common.email.content1");
            Constants.COMMON_MAIL_CONTENT2 = configProp.get("common.email.content2");
            Constants.REGISTER_EMAIL_CONTENT1 = configProp.get("register.email.content1");
            Constants.REGISTER_EMAIL_CONTENT3 = configProp.get("register.email.content3");
            Constants.REGISTER_EMAIL_CONTENT5 = configProp.get("register.email.content5");
            Constants.REGISTER_EMAIL_SUBJECT = configProp.get("register.email.subject");
            Constants.FORGET_EMAIL_SUBJECT = configProp.get("forget.email.subject");
            Constants.FORGET_EMAIL_CONTENT1 = configProp.get("forget.email.content1");
            Constants.FORGET_EMAIL_CONTENT3 = configProp.get("forget.email.content3");
            Constants.FORGET_EMAIL_CONTENT5 = configProp.get("forget.email.content5");
            Constants.CHANGE_EMAIL_CONTENT1 = configProp.get("change.email.content1");
            Constants.CHANGE_EMAIL_CONTENT3 = configProp.get("change.email.content3");
            Constants.CHANGE_EMAIL_CONTENT5 = configProp.get("change.email.content5");
            Constants.CHANGE_EMAIL_SUBJECT = configProp.get("change.email.subject");
            Constants.MODIFY_EMAIL_CONTENT1 = configProp.get("modify.email.content1");
            Constants.MODIFY_EMAIL_CONTENT3 = configProp.get("modify.email.content3");
            Constants.MODIFY_EMAIL_CONTENT5 = configProp.get("modify.email.content5");
            Constants.MODIFY_EMAIL_SUBJECT = configProp.get("modify.email.subject");
            Constants.RESET_EMAIL_CONTENT1 = configProp.get("reset.email.content1");
            Constants.RESET_EMAIL_CONTENT3 = configProp.get("reset.email.content3");
            Constants.RESET_EMAIL_CONTENT5 = configProp.get("reset.email.content5");
            Constants.RESET_EMAIL_CONTENT7 = configProp.get("reset.email.content7");
            Constants.RESET_EMAIL_CONTENT9 = configProp.get("reset.email.content9");
            Constants.RESET_EMAIL_CONTENT11 = configProp.get("reset.email.content11");
            Constants.RESET_EMAIL_CONTENT13 = configProp.get("reset.email.content13");
            Constants.RESET_EMAIL_SUBJECT = configProp.get("reset.email.subject");
            Constants.REJECT_EMAIL_CONTENT1 = configProp.get("reject.email.content1");
            Constants.REJECT_EMAIL_CONTENT3 = configProp.get("reject.email.content3");
            Constants.REJECT_EMAIL_CONTENT5 = configProp.get("reject.email.content5");
            Constants.REJECT_EMAIL_SUBJECT = configProp.get("reject.email.subject");
            Constants.PASS_EMAIL_CONTENT1 = configProp.get("pass.email.content1");
            Constants.PASS_EMAIL_CONTENT3 = configProp.get("pass.email.content3");
            Constants.PASS_EMAIL_SUBJECT = configProp.get("pass.email.subject");
            Constants.PASS_NOTICE_EMAIL_SUBJECT = configProp.get("pass.notice.email.subject");
            Constants.PASS_NOTICE_EMAIL_CONTENT1 = configProp.get("pass.notice.email.content1");
            Constants.PASS_NOTICE_EMAIL_CONTENT2 = configProp.get("pass.notice.email.content2");
            Constants.PASS_NOTICE_EMAIL_CONTENT3 = configProp.get("pass.notice.email.content3");
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316config\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38");
        }
    }
}

