/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.web.appcenter.action;

import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.system.entity.TAppInfo;
import com.xdja.cssp.open.system.entity.TAppInfoExtendBean;
import com.xdja.cssp.open.system.entity.TUser;
import com.xdja.cssp.open.system.service.IAppInfoService;
import com.xdja.cssp.open.system.service.IOpenAppInfoService;
import com.xdja.cssp.open.system.util.DateQueryBean;
import com.xdja.open.service.log.entity.SystemLog;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/app"})
public class AppCenterManagemet
extends BaseAction {
    private IAppInfoService appInfoService = (IAppInfoService)DefaultServiceRefer.getServiceRefer(IAppInfoService.class);
    private IOpenAppInfoService openAppInfoService = (IOpenAppInfoService)DefaultServiceRefer.getServiceRefer(IOpenAppInfoService.class);

    @RequestMapping(value={"/appCenter/ajaxList.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object ajaxList(TAppInfoExtendBean appInfoExtendBean, Long pageNo, Integer pageSize, DateQueryBean queryBean) {
        try {
            return this.appInfoService.ajaxAppInfoList(appInfoExtendBean, pageNo, pageSize.intValue(), queryBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ReturnCodeUtil(102, "\u83b7\u53d6\u5e94\u7528\u7ba1\u7406\u5217\u8868\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"/appCenter/queryAppDetail.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object queryAppDetail(String appId) {
        String message = "success";
        if (StringUtils.isBlank((CharSequence)appId)) {
            message = "\u53c2\u6570\u9519\u8bef";
            return new ReturnCodeUtil(1, message);
        }
        try {
            TAppInfo appInfo = this.appInfoService.queryAppDetail(appId);
            return new ReturnCodeUtil((Object)appInfo);
        }
        catch (Exception e) {
            message = "\u67e5\u8be2\u5e94\u7528\u8be6\u60c5\u51fa\u9519";
            this.logger.error(message, (Throwable)e);
            return new ReturnCodeUtil(2, message);
        }
    }

    @RequestMapping(value={"/appCenter/deleteApplication.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteApplication(String appId) {
        return null;
    }

    @RequestMapping(value={"/appCenter/revokeAuthorize.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object revokeAuthorize(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return new ReturnCodeUtil(103, "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        try {
            this.appInfoService.revokeAuthorize(appId);
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u6210\u529f\u64a4\u9500\u4e86\u5e94\u7528{}\u7684\u6388\u6743", (Object)currUser.getUserName(), (Object)appId);
            return new ReturnCodeUtil((Object)"\u64a4\u9500\u6388\u6743\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u64a4\u9500\u5e94\u7528" + appId + "\u6388\u6743\u5931\u8d25", (Throwable)e);
            return new ReturnCodeUtil(101, "\u64a4\u9500\u6388\u6743\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/appCenter/startoverAuthorize.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object startoverAuthorize(String appId) {
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            return new ReturnCodeUtil(103, "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        try {
            this.appInfoService.startoverAuthorize(appId);
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u6210\u529f\u5f00\u542f\u5e94\u7528{}\u7684\u6388\u6743", (Object)currUser.getUserName(), (Object)appId);
            return new ReturnCodeUtil((Object)"\u5f00\u542f\u6388\u6743\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u5f00\u542f\u5e94\u7528" + appId + "\u6388\u6743\u5931\u8d25", (Throwable)e);
            return new ReturnCodeUtil(101, "\u5f00\u542f\u6388\u6743\u5931\u8d25");
        }
    }
}

