/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.open.web.consumer.action;

import com.xdja.cssp.open.core.util.ReturnCodeUtil;
import com.xdja.cssp.open.service.developer.service.DeveloperInfoService;
import com.xdja.cssp.open.system.entity.TAccountInfo;
import com.xdja.cssp.open.system.entity.TUser;
import com.xdja.cssp.open.system.service.IAccountInfoService;
import com.xdja.cssp.open.system.util.DateQueryBean;
import com.xdja.open.service.log.entity.SystemLog;
import com.xdja.platform.core.Constants;
import com.xdja.platform.log.LoggerExtData;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.security.utils.OperatorUtil;
import com.xdja.platform.web.action.BaseAction;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class CommonCustomerAction
extends BaseAction {
    private IAccountInfoService accountInfoService = (IAccountInfoService)DefaultServiceRefer.getServiceRefer(IAccountInfoService.class);
    private DeveloperInfoService developerInfoService = (DeveloperInfoService)DefaultServiceRefer.getServiceRefer(DeveloperInfoService.class);

    @RequestMapping(value={"/common/ajaxList.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object ajaxList(Long pageNo, Integer pageSize, TAccountInfo condition, DateQueryBean queryBean) {
        ReturnCodeUtil returnCodeUtil;
        if (null == pageSize || null == pageNo) {
            return new ReturnCodeUtil(101, "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        if (pageNo == 0L) {
            return new ReturnCodeUtil(102, "\u5f53\u524d\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageSize == 0) {
            return new ReturnCodeUtil(103, "\u6bcf\u9875\u603b\u6570\u636e\u6761\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            returnCodeUtil = this.accountInfoService.ajaxAccountInfoList(pageNo, pageSize.intValue(), condition, queryBean);
        }
        catch (Exception e) {
            returnCodeUtil = new ReturnCodeUtil(104, "\u5206\u9875\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        return returnCodeUtil;
    }

    @RequestMapping(value={"/common/queryInfoDetail.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object queryInfoDetail(HttpServletResponse response, Long userId) {
        if (null == userId) {
            return new ReturnCodeUtil(101, "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        String msg = "success";
        try {
            TAccountInfo message = this.accountInfoService.getAccountInfoByAccountId(userId);
            if (null != message.getHeadImg() && StringUtils.isNotBlank((CharSequence)message.getHeadImg())) {
                if (null == message.getHeadImgTime()) {
                    message.setHeadImg(Constants.FASTDFS_DOWNLOAD_URL + message.getHeadImg());
                } else {
                    message.setHeadImg(this.developerInfoService.getUploadPicUrl(message.getHeadImg(), null, Boolean.valueOf(false)));
                }
            }
            return new ReturnCodeUtil((Object)message);
        }
        catch (IllegalArgumentException e) {
            msg = "\u8bf7\u6c42\u67e5\u770b\u8be6\u60c5\u53c2\u6570\u5f02\u5e38";
            this.logger.error(msg, (Throwable)e);
            return new ReturnCodeUtil(102, msg);
        }
        catch (Exception e) {
            msg = "\u67e5\u770b\u8be6\u60c5\u5931\u8d25";
            this.logger.error(msg, (Throwable)e);
            return new ReturnCodeUtil(103, msg);
        }
    }

    @RequestMapping(value={"/common/resetPwd.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object resetPassword(HttpServletResponse response, Long userId) {
        String errDesc = "";
        try {
            this.accountInfoService.resetPwd(userId);
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u6210\u529f\u91cd\u7f6e\u4e86\u666e\u901a\u7528\u6237\u7684\u5bc6\u7801\uff0c\u7528\u6237ID\u4e3a{}", (Object)currUser.getUserName(), (Object)userId);
            return new ReturnCodeUtil((Object)"\u666e\u901a\u7528\u6237\u91cd\u7f6e\u5bc6\u7801\u6210\u529f");
        }
        catch (IllegalArgumentException e) {
            errDesc = "\u666e\u901a\u7528\u6237\u91cd\u7f6e\u5bc6\u7801\u65f6\u53c2\u6570\u5f02\u5e38";
            this.logger.error(errDesc, (Throwable)e);
            return new ReturnCodeUtil(101, errDesc);
        }
        catch (Exception e) {
            errDesc = "\u666e\u901a\u7528\u6237\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25";
            this.logger.error("\u7528\u6237\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (Throwable)e);
            return new ReturnCodeUtil(102, errDesc);
        }
    }

    @RequestMapping(value={"/common/forbiddenUser.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object forbiddenUser(HttpServletResponse response, Long userId) {
        String message = "success";
        try {
            this.accountInfoService.forbiddenUser(userId);
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u7981\u7528\u666e\u901a\u7528\u6237\u6210\u529f\uff0c\u7528\u6237ID\u4e3a{}", (Object)currUser.getUserName(), (Object)userId);
            return new ReturnCodeUtil((Object)"\u7981\u7528\u666e\u901a\u7528\u6237\u6210\u529f");
        }
        catch (IllegalArgumentException e) {
            message = "\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5";
            this.logger.error(message, (Throwable)e);
            return new ReturnCodeUtil(101, message);
        }
        catch (Exception e) {
            message = "\u7981\u7528\u666e\u901a\u7528\u6237\u5931\u8d25";
            this.logger.error(message, (Throwable)e);
            return new ReturnCodeUtil(102, message);
        }
    }

    @RequestMapping(value={"/common/startoverUser.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object startoverUser(HttpServletResponse response, Long userId) {
        String message = "success";
        try {
            this.accountInfoService.startoverUser(userId);
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u542f\u7528\u666e\u901a\u8d26\u6237\u6210\u529f\uff0c\u7528\u6237ID\u4e3a{}", (Object)currUser.getUserName(), (Object)userId);
            return new ReturnCodeUtil((Object)"\u542f\u7528\u666e\u901a\u7528\u6237\u8d26\u6237\u6210\u529f");
        }
        catch (IllegalArgumentException e) {
            message = "\u542f\u7528\u666e\u901a\u7528\u6237\u65f6\u53c2\u6570\u5f02\u5e38";
            this.logger.error(message, (Throwable)e);
            return new ReturnCodeUtil(101, message);
        }
        catch (Exception e) {
            message = "\u542f\u7528\u666e\u901a\u7528\u6237\u5931\u8d25";
            this.logger.error(message, (Throwable)e);
            return new ReturnCodeUtil(102, message);
        }
    }

    @RequestMapping(value={"/common/deleteUser.do"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object deleteUser(HttpServletResponse response, Long userId) {
        String message = "success";
        try {
            this.accountInfoService.deleteUser(userId);
            TUser currUser = (TUser)OperatorUtil.getOperator().getCurrUser();
            this.logger.info(SystemLog.ENUM_LOG_TYPE.operateLog.value.intValue(), LoggerExtData.create((String)"modelType", (Object)SystemLog.ENUM_LOG_MODEL_TYPE.systemManagerLog.value), "\u7ba1\u7406\u5458{}\u5220\u9664\u4e86\u666e\u901a\u7528\u6237,\u7528\u6237ID\u4e3a{}", (Object)currUser.getUserName(), (Object)userId);
            return new ReturnCodeUtil((Object)"\u5220\u9664\u666e\u901a\u7528\u6237\u6210\u529f");
        }
        catch (IllegalArgumentException e) {
            message = "\u5220\u9664\u666e\u901a\u7528\u6237\u65f6\u53c2\u6570\u5f02\u5e38";
            this.logger.error(message, (Throwable)e);
            return new ReturnCodeUtil(101, message);
        }
        catch (Exception e) {
            message = "\u5220\u9664\u666e\u901a\u7528\u6237\u5931\u8d25";
            this.logger.error(message, (Throwable)e);
            return new ReturnCodeUtil(102, message);
        }
    }
}

